#!/bin/bash

# 项目路径
PROJECT_DIR=$(pwd)

# 源代码位置
SOURCE_FILE="./main.go"

# Windows 编译
echo "开始编译 Windows 版本..."
GOOS=windows GOARCH=amd64 go build -o "$PROJECT_DIR/my_app_windows.exe" "$SOURCE_FILE"
if [ $? -eq 0 ]; then
  echo "Windows 版本编译成功：my_app_windows.exe"
else
  echo "Windows 版本编译失败"
  exit 1
fi

# macOS 编译
echo "开始编译 macOS 版本..."
GOOS=darwin GOARCH=amd64 go build -o "$PROJECT_DIR/my_app_mac" "$SOURCE_FILE"
if [ $? -eq 0 ]; then
  echo "macOS 版本编译成功：my_app_mac"
else
  echo "macOS 版本编译失败"
  exit 1
fi

echo "所有平台编译完成！"
