# 退货单管理API文档

## 1. 提交退货单

### 接口信息
- **URL**: `POST /returnGoods/submitReturnGoods`
- **描述**: 提交退货单，支持多个商品批量退货
- **Content-Type**: `application/json`

### 请求参数

```json
{
    "articuloList": [
        {
            "amount": -1,
            "nombre": "Sopa de costillas",
            "precio": 33.3,
            "type": 0,
            "value": "1"
        },
        {
            "amount": -10,
            "nombre": "Articulo",
            "precio": 50.0,
            "type": 0,
            "value": "0"
        }
    ],
    "empresaId": "2"
}
```

#### 参数说明

| 参数名 | 类型 | 必需 | 描述 |
|--------|------|------|------|
| articuloList | array | 是 | 商品列表 |
| articuloList[].amount | integer | 是 | 退货数量（负数） |
| articuloList[].nombre | string | 是 | 商品名称 |
| articuloList[].precio | number/integer | 是 | 商品价格 |
| articuloList[].type | integer | 是 | 商品标识类型：0-商品ID，1-条码 |
| articuloList[].value | string | 是 | 商品ID或条码值 |
| empresaId | string | 是 | 企业ID |

### 响应格式

#### 成功响应 (200)
```json
{
    "code": 200,
    "message": "退货单创建成功",
    "data": {
        "returnOrderId": 1703123456,
        "totalSubTotal": -533.3,
        "processedProducts": [
            {
                "productId": 1,
                "productName": "Sopa de costillas",
                "amount": -1,
                "precio": 33.3,
                "subTotal": -33.3
            },
            {
                "productId": 0,
                "productName": "Articulo",
                "amount": -10,
                "precio": 50.0,
                "subTotal": -500.0
            }
        ],
        "empresaId": "2"
    }
}
```

#### 错误响应

**参数错误 (400)**
```json
{
    "code": 400,
    "message": "请求参数错误: 具体错误信息"
}
```

**商品不存在 (404)**
```json
{
    "code": 404,
    "message": "商品不存在: 商品ID或条码"
}
```

**服务器错误 (500)**
```json
{
    "code": 500,
    "message": "创建退货订单失败"
}
```

### 业务逻辑

1. **参数验证**：
   - 验证商品列表不能为空
   - 验证企业ID不能为空
   - 验证退货数量必须为负数
   - 验证商品类型（0或1）

2. **商品查询**：
   - 根据type字段确定查询方式
   - type=0：通过商品ID查询
   - type=1：通过条码查询

3. **数据处理**：
   - 为每个商品创建退货明细记录
   - 更新商品库存（增加库存）
   - 创建退货订单记录
   - 计算总金额

4. **事务处理**：
   - 使用数据库事务确保数据一致性
   - 任何步骤失败都会回滚所有操作

### 使用示例

#### cURL示例
```bash
curl -X POST "http://localhost:8080/returnGoods/submitReturnGoods" \
  -H "Content-Type: application/json" \
  -d '{
    "articuloList": [
        {
            "amount": -1,
            "nombre": "Sopa de costillas",
            "precio": 33.3,
            "type": 0,
            "value": "1"
        },
        {
            "amount": -10,
            "nombre": "Articulo",
            "precio": 50.0,
            "type": 0,
            "value": "0"
        }
    ],
    "empresaId": "2"
}'
```

#### JavaScript示例
```javascript
const response = await fetch('/returnGoods/submitReturnGoods', {
    method: 'POST',
    headers: {
        'Content-Type': 'application/json',
    },
    body: JSON.stringify({
        articuloList: [
            {
                amount: -1,
                nombre: "Sopa de costillas",
                precio: 33.3,
                type: 0,
                value: "1"
            },
            {
                amount: -10,
                nombre: "Articulo",
                precio: 50.0,
                type: 0,
                value: "0"
            }
        ],
        empresaId: "2"
    })
});

const result = await response.json();
console.log(result);
```

### 注意事项

1. **退货数量**：必须为负数，表示退货
2. **商品查询**：支持通过商品ID或条码两种方式查询
3. **库存更新**：退货会增加商品库存
4. **事务安全**：所有操作在事务中执行，确保数据一致性
5. **错误处理**：详细的错误信息帮助调试

## 2. 获取退货单列表

### 接口信息
- **URL**: `POST /returnGoods/listReturnGoods`
- **描述**: 获取所有退货订单列表
- **Content-Type**: `application/x-www-form-urlencoded`

### 查询参数

| 参数名 | 类型 | 必需 | 描述 |
|--------|------|------|------|
| Bloqueado | string | 否 | 审核状态过滤 |
| orderId | string | 否 | 订单编号过滤 |
| supplierId | string | 否 | 供应商ID过滤 |

### 响应格式

#### 成功响应 (200)
```json
{
    "code": 200,
    "message": "获取退货单列表成功",
    "data": [
        {
            "OrderID": 1703123456,
            "SubTotal": -533.3,
            "Status": "已结账",
            "OrderDate": "2023-12-21T10:30:00Z",
            "SupplierCompanyName": "供应商名称"
        }
    ]
}
```

## 3. 获取退货单商品列表

### 接口信息
- **URL**: `POST /returnGoods/ReturnGoodsProductList`
- **描述**: 获取指定退货单的商品明细
- **Content-Type**: `application/x-www-form-urlencoded`

### 查询参数

| 参数名 | 类型 | 必需 | 描述 |
|--------|------|------|------|
| orderId | string | 是 | 订单编号 |

### 响应格式

#### 成功响应 (200)
```json
{
    "code": 200,
    "message": "获取退货单商品列表成功",
    "data": [
        {
            "ProductID": 1,
            "ProductName": "Sopa de costillas",
            "Quantity": -1,
            "UnitPrice": 33.3,
            "PricePurchase": 30.0
        }
    ]
}
```

## 4. 添加商品到退货单

### 接口信息
- **URL**: `POST /returnGoods/addReturnedArticulo`
- **描述**: 向现有退货单添加商品
- **Content-Type**: `application/json`

### 请求参数

```json
{
    "articuloList": [
        {
            "amount": -1,
            "nombre": "商品名称",
            "precio": 33.3,
            "type": 0,
            "value": "1"
        }
    ],
    "empresaId": "2"
}
```

### 查询参数

| 参数名 | 类型 | 必需 | 描述 |
|--------|------|------|------|
| documentoNo | string | 是 | 退货单号 |

## 5. 更新退货单审核状态

### 接口信息
- **URL**: `POST /returnGoods/bloqueado`
- **描述**: 更新退货单的审核状态
- **Content-Type**: `application/x-www-form-urlencoded`

### 表单参数

| 参数名 | 类型 | 必需 | 描述 |
|--------|------|------|------|
| documentoNo | string | 是 | 退货单号 |
| bloqueado | string | 是 | 审核状态：0-未审核，1-已审核 |

## 6. 删除退货单商品

### 接口信息
- **URL**: `POST /returnGoods/deleteReturnedArticulo`
- **描述**: 删除退货单中的所有商品
- **Content-Type**: `application/x-www-form-urlencoded`

### 表单参数

| 参数名 | 类型 | 必需 | 描述 |
|--------|------|------|------|
| documentoNo | string | 是 | 退货单号 |

## 7. 修改退货单商品信息

### 接口信息
- **URL**: `POST /returnGoods/updateReturnedArticulo`
- **描述**: 修改退货单中指定商品的信息
- **Content-Type**: `application/x-www-form-urlencoded`

### 表单参数

| 参数名 | 类型 | 必需 | 描述 |
|--------|------|------|------|
| documentoNo | string | 是 | 退货单号 |
| code | string | 是 | 商品ID |
| amount | string | 是 | 商品数量 |
| precio | string | 是 | 商品价格 | 