# ReturnGoodsProductList 接口修改说明

## 修改概述

对 `ReturnGoodsProductList` 接口进行了以下增强：

1. **新增供应商名称返回**：接口现在会返回供应商的公司名称
2. **支持多条件查询**：支持通过订单号、供应商编号和审核状态进行查询
3. **灵活的查询条件**：所有查询条件都是可选的，可以组合使用

## 修改详情

### 1. 新增数据结构

在 `models/purchase_details.go` 中新增了 `PurchaseDetailsWithProductAndSupplier` 结构体：

```go
type PurchaseDetailsWithProductAndSupplier struct {
    // PurchaseDetails 字段
    Id                 int      `json:"id"`
    OrderId            *int     `json:"orderid"`
    ProductId          int      `json:"productid"`
    // ... 其他 PurchaseDetails 字段

    // Products 表字段
    PricePurchase float64  `json:"pricepurchase"`
    PdUnitPrice   float64  `json:"pdunitprice"`
    UnitPrice4    *float64 `json:"unitprice4"`

    // Suppliers 表字段
    SupplierCompanyName *string `json:"supplierCompanyName"` // 供应商公司名称
}
```

### 2. 接口参数

接口现在支持以下查询参数：

| 参数名 | 类型 | 必填 | 说明 |
|--------|------|------|------|
| documentoNo | string | 否 | 订单编号 |
| supplierId | string | 否 | 供应商编号 |
| bloqueado | string | 否 | 审核状态，-1表示全部 |

### 3. 查询逻辑

- **订单号查询**：当 `documentoNo` 不为空时，添加 `pd.OrderID = ?` 条件
- **供应商编号查询**：当 `supplierId` 不为空时，添加 `p.SupplierID = ?` 条件
- **审核状态查询**：当 `bloqueado` 不为空且不等于 "-1" 时，添加 `pu.Bloqueado = ?` 条件
- **全部查询**：当所有参数都为空时，返回所有退货单商品

### 4. 数据库查询

修改后的查询语句：

```sql
SELECT pd.*, p.PricePurchase, p.UnitPrice as pdunitprice, p.UnitPrice4, s.CompanyName as SupplierCompanyName
FROM "Purchase Details" pd
LEFT JOIN Products p ON pd.ProductID = p.ProductID
LEFT JOIN Suppliers s ON p.SupplierID = s.SupplierID
LEFT JOIN Purchase pu ON pd.OrderID = pu.OrderID
WHERE 1=1
[AND pd.OrderID = ?]  -- 可选：订单号条件
[AND p.SupplierID = ?]  -- 可选：供应商编号条件
[AND pu.Bloqueado = ?]  -- 可选：审核状态条件
ORDER BY pd.ID DESC
```

## 使用示例

### 1. 查询指定订单的商品
```
GET /returnGoods/ReturnGoodsProductList?documentoNo=12345
```

### 2. 查询指定供应商的商品
```
GET /returnGoods/ReturnGoodsProductList?supplierId=100
```

### 3. 查询已审核的商品
```
GET /returnGoods/ReturnGoodsProductList?bloqueado=1
```

### 4. 组合查询
```
GET /returnGoods/ReturnGoodsProductList?documentoNo=12345&supplierId=100&bloqueado=0
```

### 5. 查询全部（不传参数或审核状态为-1）
```
GET /returnGoods/ReturnGoodsProductList
GET /returnGoods/ReturnGoodsProductList?bloqueado=-1
```

## 返回数据格式

```json
{
  "code": 200,
  "message": "获取退货单商品列表成功",
  "data": [
    {
      "id": 1,
      "orderid": 12345,
      "productid": 100,
      "productname": "测试商品",
      "quantity": -5.0,
      "unitprice": 10.50,
      "pricepurchase": 8.00,
      "pdunitprice": 10.50,
      "supplierCompanyName": "测试供应商"
    }
  ]
}
```

## 注意事项

1. 所有查询条件都是可选的，可以单独使用或组合使用
2. 审核状态参数 `bloqueado` 为 "-1" 时表示查询全部，不会添加审核状态条件
3. 查询结果按 `pd.ID DESC` 排序
4. 接口会记录详细的查询条件日志，便于调试和监控
