# 退货控制器商品查询逻辑优化

## 修改概述

对 `controllers/return_controller.go` 文件进行了优化，实现了统一的商品查询逻辑，按照 ProductID、BarCode、UserCode 的顺序进行查询。

## 主要修改

### 1. 新增统一查询方法

添加了 `findProductByValue` 方法：

```go
func (re *ReturnController) findProductByValue(tx *gorm.DB, value string) (models.Products, error)
```

该方法按照以下顺序查询商品：
1. **ProductID**: 首先尝试将输入值解析为数字，然后按 ProductID 查询
2. **BarCode**: 如果 ProductID 查询失败，按 BarCode 查询
3. **UserCode**: 如果 BarCode 查询失败，按 UserCode 查询
4. **返回错误**: 如果所有查询都失败，返回 `gorm.ErrRecordNotFound` 错误

### 2. 修改的方法

#### SubmitReturnGoods 方法
- **原逻辑**: 根据 `articulo.Type` 字段决定查询方式（0=ProductID, 1=BarCode）
- **新逻辑**: 使用统一的 `findProductByValue` 方法，自动尝试所有查询方式

#### AddReturnedArticulo 方法
- **原逻辑**: 根据 `articulo.Type` 字段决定查询方式
- **新逻辑**: 使用统一的 `findProductByValue` 方法

#### UpdateReturnedArticulo 方法
- **原逻辑**: 只支持通过 ProductID 查询
- **新逻辑**: 使用统一的 `findProductByValue` 方法，支持多种查询方式

### 3. 查询优先级

1. **ProductID**: 最高优先级，如果输入值是数字且存在对应商品
2. **BarCode**: 中等优先级，如果 ProductID 查询失败
3. **UserCode**: 最低优先级，如果前两种查询都失败

## 优势

1. **简化代码**: 消除了重复的商品查询逻辑
2. **提高灵活性**: 不再需要指定查询类型，系统自动尝试所有方式
3. **增强用户体验**: 用户可以使用任意一种标识符查询商品
4. **统一错误处理**: 所有查询失败的情况都返回相同的错误信息

## 测试

创建了 `controllers/return_controller_test.go` 测试文件，包含以下测试用例：
- 通过 ProductID 查询
- 通过 BarCode 查询
- 通过 UserCode 查询
- 查询不存在的商品
- 查询空字符串

## 使用示例

```go
// 以下查询都会返回同一个商品（如果存在）
product, err := controller.findProductByValue(tx, "1")           // 通过 ProductID
product, err := controller.findProductByValue(tx, "123456789")   // 通过 BarCode
product, err := controller.findProductByValue(tx, "USER001")     // 通过 UserCode
```

## 注意事项

1. 查询顺序是固定的，不能通过参数调整
2. 如果多个字段值相同，会按照优先级返回第一个匹配的商品
3. 所有查询都使用 `SELECT TOP 1` 确保只返回一条记录
4. 错误日志会记录具体的查询方式和失败原因
