package models

// ScanResponse 扫描响应
type ScanResponse struct {
	Code    string  `json:"code"`
	Data    Product `json:"data"`
	Message string  `json:"message"`
}

type Product struct {
	ProductID     string  `json:"productid"`
	BarCode       string  `json:"barcode"`
	UserCode      string  `json:"usercode"`
	ProductName   string  `json:"productname"`
	ProductName2  string  `json:"productname2"`
	PricePurchase float64 `json:"pricepurchase"`
	UnitPrice     float64 `json:"unitprice"`
	UnitPrice2    float64 `json:"unitprice2"`
	Tax           float32 `json:"tax"`
	SupplierID    string  `json:"supplierid"`
	CategoryID    string  `json:"categoryid"`
	Discount      int     `json:"discount"`
	Height        string  `json:"height"`
	Width         string  `json:"width"`
	Color         string  `json:"color"`
	UnitsInStock  float64 `json:"unitsinstock"`
}

// AddProductRequest 添加商品请求
type AddProductRequest struct {
	UserCode      string `json:"usercode" binding:"required"`
	BarCode       string `json:"barcode"`
	ProductName   string `json:"productname" binding:"required"`
	ProductName2  string `json:"productname2"`
	PricePurchase string `json:"pricepurchase"`
	UnitPrice     string `json:"unitprice"`
	UnitPrice2    string `json:"unitprice2"`
	CategoryID    string `json:"categoryid"`
	CategoryName  string `json:"categoryname"`
	SupplierID    string `json:"supplierid"`
	UnitsInStock  string `json:"unitsinstock"`
	Discount      string `json:"discount"`
	Tax           string `json:"tax"`
	CompanyName   string `json:"companyname"`
	Observacion   string `json:"observacion"`
}

// UpdateProductRequest 修改商品请求
type UpdateProductRequest struct {
	ProductID     string `json:"productid" binding:"required"`
	UserCode      string `json:"usercode"`
	BarCode       string `json:"barcode"`
	ProductName   string `json:"productname"`
	ProductName2  string `json:"productname2"`
	PricePurchase string `json:"pricepurchase"`
	UnitPrice     string `json:"unitprice"`
	UnitPrice2    string `json:"unitprice2"`
	CategoryID    string `json:"categoryid"`
	CategoryName  string `json:"categoryname"`
	SupplierID    string `json:"supplierid"`
	UnitsInStock  string `json:"unitsinstock"`
	Discount      string `json:"discount"`
	Tax           string `json:"tax"`
	CompanyName   string `json:"companyname"`
	Observacion   string `json:"observacion"`
}
