package models

// Categories 分类模型
// 对应数据库中的Categories表，包含商品分类的所有属性信息
type Categories struct {
	CategoryId        int     `json:"categoryid" gorm:"primaryKey;autoIncrement;column:CategoryID"`
	CategoryName      string  `json:"categoryname" gorm:"column:CategoryName;type:nvarchar(50);not null"`
	CategoryName2     *string `json:"categoryname2" gorm:"column:CategoryName2;type:nvarchar(200)"`
	Description       *string `json:"description" gorm:"column:Description;type:nvarchar(max)"`
	Fjson            *string `json:"fjson" gorm:"column:fjson;type:nvarchar(max)"`
	Picture          []byte  `json:"picture" gorm:"column:Picture;type:image"`
	ReserveFunction   *string `json:"reserve_function" gorm:"column:Reserve_function;type:nvarchar(200)"`
	SupplierId       *int    `json:"supplierid" gorm:"column:SupplierID"`
	TimeStampPicture *string `json:"timestamppicture" gorm:"column:TimeStampPicture;type:nvarchar(200)"`
	Type1            *string `json:"type1" gorm:"column:type1;type:nvarchar(3000)"`
	SellerId         *int    `json:"sellerid" gorm:"column:SellerID"`
	PrintCookTicket  *bool   `json:"printcookticket" gorm:"column:PrintCookTicket;type:bit"`
	PrintCookTicket2 *bool   `json:"printcookticket2" gorm:"column:PrintCookTicket2;type:bit"`
	PrintCookTicketII *bool  `json:"printcookticketii" gorm:"column:PrintCookTicketII;type:bit"`
	PrintGroup       *int    `json:"printgroup" gorm:"column:PrintGroup"`
	CategoryParentId *int    `json:"categoryparentid" gorm:"column:CategoryParentID"`
	CategoryNameES   *string `json:"categorynamees" gorm:"column:CategoryNameES;type:nvarchar(200)"`
	CategoryName2ES  *string `json:"categoryname2es" gorm:"column:CategoryName2ES;type:nvarchar(200)"`
	DiscountsStart   *int    `json:"discountsstart" gorm:"column:DiscountsStart"`
	Color            *string `json:"color" gorm:"column:Color;type:nvarchar(128)"`
	ForeColor        *string `json:"forecolor" gorm:"column:ForeColor;type:nvarchar(128)"`
}

func (c *Categories) TableName() string {
	return "Categories"
}