// Package models 包含所有的数据模型定义
// 定义了与数据库表对应的结构体，用于数据映射和序列化
package models

import "time"

// Products 产品模型
// 对应数据库中的Products表，包含商品的所有属性信息
type Products struct {
	ProductId            int64     `json:"productid" gorm:"primaryKey;autoIncrement;column:ProductID"`
	BarCode              string    `json:"barcode" gorm:"column:BarCode"`
	UserCode             string    `json:"usercode" gorm:"column:UserCode"`
	ProductName          string    `json:"productname" gorm:"column:ProductName"`
	ProductName2         string    `json:"productname2" gorm:"column:ProductName2"`
	ProductName3         string    `json:"productname3" gorm:"column:ProductName3"`
	ProductName4         string    `json:"productname4" gorm:"column:ProductName4"`
	ProductName5         string    `json:"productname5" gorm:"column:ProductName5"`
	PricePurchase        float64   `json:"pricepurchase" gorm:"column:PricePurchase;type:decimal(19,4)"`
	UnitPrice            float64   `json:"unitprice" gorm:"column:UnitPrice;type:decimal(19,4)"`
	UnitPrice2           *float64  `json:"unitprice2" gorm:"column:UnitPrice2;type:decimal(19,4)"`
	UnitPrice3           *float64  `json:"unitprice3" gorm:"column:UnitPrice3;type:decimal(19,4)"`
	UnitPrice4           *float64  `json:"unitprice4" gorm:"column:UnitPrice4;type:decimal(19,4)"`
	UnitPrice5           *float64  `json:"unitprice5" gorm:"column:UnitPrice5;type:decimal(19,4)"`
	UnitPrice6           *float64  `json:"unitprice6" gorm:"column:UnitPrice6;type:decimal(19,4)"`
	UnitPrice7           *float64  `json:"unitprice7" gorm:"column:UnitPrice7;type:decimal(19,4)"`
	UnitPrice8           *float64  `json:"unitprice8" gorm:"column:UnitPrice8;type:decimal(19,4)"`
	UnitPriceAvg         float64   `json:"unitpriceavg" gorm:"column:UnitPriceAVG;type:decimal(19,4)"`
	UnitPriceLast        *float64  `json:"unitpricelast" gorm:"column:UnitPriceLast;type:decimal(19,4)"`
	Tax                  float32   `json:"tax" gorm:"column:Tax;type:real"`
	SupplierId           int       `json:"supplierid" gorm:"column:SupplierID;default:1"`
	CategoryId           int       `json:"categoryid" gorm:"column:CategoryID;default:1"`
	QuantityPerUnit      int       `json:"quantityperunit" gorm:"column:QuantityPerUnit;default:1"`
	QuantityPerUnit2nd   int       `json:"quantityperunit2nd" gorm:"column:QuantityPerUnit2nd;default:1"`
	UnitsInStock         float64   `json:"unitsinstock" gorm:"column:UnitsInStock;type:float;default:0"`
	UnitsOnOrder         float64   `json:"unitsonorder" gorm:"column:UnitsOnOrder;type:float;default:0"`
	UnitsOnPurchase      float64   `json:"unitsonpurchase" gorm:"column:UnitsOnPurchase;type:float;default:0"`
	MarketingNo          int       `json:"marketingno" gorm:"column:MarketingNO;default:0"`
	Discontinued         *bool     `json:"discontinued" gorm:"column:Discontinued;type:bit"`
	Discount             int       `json:"discount" gorm:"column:Discount;default:0"`
	DToStartDate         *time.Time `json:"dtostartdate" gorm:"column:DtoStartDate;type:datetime"`
	DToExipDate          *time.Time `json:"dtoexipdate" gorm:"column:DtoExipDate;type:datetime"`
	Remark               string    `json:"remark" gorm:"column:Remark;type:nvarchar(max)"`
	ReorderLevel         *float64  `json:"reorderlevel" gorm:"column:ReorderLevel;type:float"`
	StorageLocation      string    `json:"storagelocation" gorm:"column:StorageLocation;type:nvarchar(100)"`
	Timestamp            string    `json:"timestamp" gorm:"column:timestamp;type:nvarchar(128)"`
	Picture              string    `json:"picture" gorm:"column:Picture;type:nvarchar(max)"`
	Fjson                string    `json:"fjson" gorm:"column:fjson;type:nvarchar(max)"`
	Fjson2               string    `json:"fjson2" gorm:"column:fjson2;type:nvarchar(3000)"`
	Hide                 *bool     `json:"hide" gorm:"column:hide;type:bit"`
	Leng2ProductName     string    `json:"leng2productname" gorm:"column:Leng2ProductName"`
	Leng3ProductName     string    `json:"leng3productname" gorm:"column:Leng3ProductName"`
	Leng4ProductName     string    `json:"leng4productname" gorm:"column:Leng4ProductName"`
	Leng5ProductName     string    `json:"leng5productname" gorm:"column:Leng5ProductName"`
	Leng2Remark          string    `json:"leng2remark" gorm:"column:Leng2Remark;type:nvarchar(500)"`
	Leng3Remark          string    `json:"leng3remark" gorm:"column:Leng3Remark;type:nvarchar(500)"`
	Leng4Remark          string    `json:"leng4remark" gorm:"column:Leng4Remark;type:nvarchar(500)"`
	Leng5Remark          string    `json:"leng5remark" gorm:"column:Leng5Remark;type:nvarchar(500)"`
	BigProductId         string    `json:"bigproductid" gorm:"column:BigProductID;type:nvarchar(128)"`
	ColorSize            string    `json:"colorsize" gorm:"column:colorsize;type:nvarchar(300)"`
	PriceFactory         *float64  `json:"pricefactory" gorm:"column:PriceFactory;type:decimal(19,4)"`
	PriceTransport       *float64  `json:"pricetransport" gorm:"column:PriceTransport;type:decimal(19,4)"`
	QuantityTotal        *float64  `json:"quantitytotal" gorm:"column:QuantityTotal;type:float"`
	Height               *float64  `json:"height" gorm:"column:height;type:float"`
	Width                *float64  `json:"width" gorm:"column:width;type:float"`
	Length               *float64  `json:"length" gorm:"column:length;type:float"`
	Weight               *float64  `json:"weight" gorm:"column:weight;type:float"`
	MaxBultos2nd         *float64  `json:"maxbultos2nd" gorm:"column:MaxBultos2nd;type:float"`
	Option1              int       `json:"option1" gorm:"column:Option1;default:0"`
	UnboxLevel           *int      `json:"unboxlevel" gorm:"column:UnboxLevel"`
	Image                []byte    `json:"image" gorm:"column:Image;type:image"`
	Views                *int      `json:"views" gorm:"column:Views"`
	Uuid                 string    `json:"uuid" gorm:"column:UUID;type:nvarchar(450)"`
	SellerId             *int      `json:"sellerid" gorm:"column:SellerID"`
	Color                string    `json:"color" gorm:"column:Color;type:nvarchar(128)"`
	Limit                *int      `json:"limit" gorm:"column:limit"`
	LimitQty             *int      `json:"limitqty" gorm:"column:limitQty"`
	Parent               string    `json:"parent" gorm:"column:Parent;type:nvarchar(128)"`
	Step                 *float32  `json:"step" gorm:"column:Step;type:real"`
	Option2              *int      `json:"option2" gorm:"column:Option2"`
	Option3              *int      `json:"option3" gorm:"column:Option3"`
	Option4              *int      `json:"option4" gorm:"column:Option4"`
	Option5              *int      `json:"option5" gorm:"column:Option5"`
	Option6              *int      `json:"option6" gorm:"column:Option6"`
	Option7              *int      `json:"option7" gorm:"column:Option7"`
	Option8              *int      `json:"option8" gorm:"column:Option8"`
	Options1             string    `json:"options1" gorm:"column:OptionS1;type:nvarchar(255)"`
	Options2             string    `json:"options2" gorm:"column:OptionS2;type:nvarchar(255)"`
	UnitPriceTaxExcluded *float64  `json:"unitpricetaxexcluded" gorm:"column:UnitPriceTaxExcluded;type:decimal(19,4)"`
	InventoryLimit       float64   `json:"inventorylimit" gorm:"column:InventoryLimit;type:decimal(19,3);default:0"`
	ForeColor            string    `json:"forecolor" gorm:"column:ForeColor;type:nvarchar(128)"`
	
	// 虚拟字段，不映射到数据库
	Img                  string `json:"img" gorm:"-"`
	SuppliersName        string `json:"suppliersName" gorm:"-"`
}

func (p *Products) TableName() string {
	return "Products"
}