// Package models 包含所有的数据模型定义
// 定义了与数据库表对应的结构体，用于数据映射和序列化
package models

import (
	"time"
)

// Purchase 采购模型
// 对应数据库中的Purchase表，包含采购单的所有属性信息
type Purchase struct {
	OrderId         int        `json:"orderId" gorm:"primaryKey;autoIncrement;column:OrderID"` // 订单ID，主键，自增
	SupplierId      *int       `json:"supplierId" gorm:"column:SupplierID"`                    // 供应商ID
	AccountPayable  *float64   `json:"accountPayable" gorm:"column:AccountPayable"`            // 应付账款
	AlbaranId       *int       `json:"albaranId" gorm:"column:AlbaranID"`                      // 采购单号
	Amount          *float64   `json:"amount" gorm:"column:Amount"`                            // 金额
	Cash            *float64   `json:"cash" gorm:"column:Cash"`                                // 现金
	CloseDate       *time.Time `json:"closeDate" gorm:"column:CloseDate"`                      // 关闭日期
	CloseTime       *time.Time `json:"closeTime" gorm:"column:CloseTime"`                      // 关闭时间
	Del             *string    `json:"del" gorm:"column:Del"`                                  // 删除标记
	Discount        *float32   `json:"discount" gorm:"column:Discount"`                        // 折扣
	Employe         *string    `json:"employe" gorm:"column:Employe"`                          // 员工
	EmployeeId      *int       `json:"employeeId" gorm:"column:EmployeeID"`                    // 员工ID
	ExchangeRate    float64    `json:"exchangeRate" gorm:"column:exchange_rate"`               // 汇率
	ExOid           string     `json:"exOid" gorm:"column:ExOID"`                              // 外部订单ID
	FacturaId       *int       `json:"facturaId" gorm:"column:FacturaID"`                      // 发票ID
	Final           string     `json:"final" gorm:"column:Final"`                              // 最终状态
	Fjson           string     `json:"fjson" gorm:"column:fjson"`                              // JSON数据
	Freight         float64    `json:"freight" gorm:"column:Freight"`                          // 运费
	LimitDate       *time.Time `json:"limitDate" gorm:"column:LimitDate"`                      // 限制日期
	OrderDate       *time.Time `json:"orderDate" gorm:"column:OrderDate"`                      // 订单日期
	OrderTime       *time.Time `json:"orderTime" gorm:"column:OrderTime"`                      // 订单时间
	OrderType       *int       `json:"orderType" gorm:"column:OrderType"`                      // 订单类型
	Paid            *float64   `json:"paid" gorm:"column:Paid"`                                // 已付金额
	PayMode         string     `json:"payMode" gorm:"column:PayMode"`                          // 支付方式
	Remark          string     `json:"remark" gorm:"column:Remark"`                            // 备注
	RequiredDate    *time.Time `json:"requiredDate" gorm:"column:RequiredDate"`                // 要求日期
	ShipAddress     string     `json:"shipAddress" gorm:"column:ShipAddress"`                  // 发货地址
	ShipCity        string     `json:"shipCity" gorm:"column:ShipCity"`                        // 发货城市
	ShipCountry     string     `json:"shipCountry" gorm:"column:ShipCountry"`                  // 发货国家
	ShipName        string     `json:"shipName" gorm:"column:ShipName"`                        // 发货名称
	ShippedDate     *time.Time `json:"shippedDate" gorm:"column:ShippedDate"`                  // 发货日期
	ShipPostalCode  string     `json:"shipPostalCode" gorm:"column:ShipPostalCode"`            // 发货邮政编码
	ShipRegion      string     `json:"shipRegion" gorm:"column:ShipRegion"`                    // 发货地区
	ShipVia         *int       `json:"shipVia" gorm:"column:ShipVia"`                          // 发货方式
	Size            *float64   `json:"size" gorm:"column:size"`                                // 尺寸
	Status          string     `json:"status" gorm:"column:Status"`                            // 状态
	SubTotal        float64    `json:"subTotal" gorm:"column:SubTotal"`                        // 小计
	TaxInclude      *bool      `json:"taxInclude" gorm:"column:TaxInclude;default:true"`       // 含税
	ValueAddTax     *float64   `json:"valueAddTax" gorm:"column:ValueAddTax"`                  // 增值税
	Vouchers        *float64   `json:"vouchers" gorm:"column:Vouchers"`                        // 代金券
	VouchersId      string     `json:"vouchersId" gorm:"column:VouchersID"`                    // 代金券ID
	Uuid            string     `json:"uuid" gorm:"column:UUID"`                                // UUID
	Sn              string     `json:"sn" gorm:"column:sn"`                                    // 序列号
	FreePosUserName string     `json:"freePosUserName" gorm:"column:FreePosUserName"`          // 免费POS用户名
	FreePosRemark   string     `json:"freePosRemark" gorm:"column:FreePosRemark"`              // 免费POS备注
	//Bloqueado       int        `json:"bloqueado" gorm:"column:Bloqueado"`
	Bloqueado *float64 `json:"bloqueado" gorm:"column:Bloqueado;type:numeric(18,3);default:null"`
}

func (p *Purchase) TableName() string {
	return "Purchase"
}

// PurchaseWithSupplier 包含供应商信息的采购单结构体
// 用于查询结果，包含供应商公司名称
type PurchaseWithSupplier struct {
	Purchase
	SupplierCompanyName string   `json:"supplierCompanyName" gorm:"column:SupplierCompanyName"` // 供应商公司名称
	Bloqueado           *float64 `json:"bloqueado" gorm:"column:Bloqueado;type:numeric(18,3);default:null"`
}
