package models

// PurchaseDetails 采购详情模型
// 对应数据库中的PurchaseDetails表，包含采购订单的详细信息
type PurchaseDetails struct {
	Id                 int      `json:"id" gorm:"primaryKey;autoIncrement;column:ID"`
	OrderId            *int     `json:"orderid" gorm:"column:OrderID"`
	ProductId          int      `json:"productid" gorm:"column:ProductID;not null"`
	UserCode           *string  `json:"usercode" gorm:"column:UserCode;type:nvarchar(128)"`
	BarCode            *string  `json:"barcode" gorm:"column:BarCode;type:nvarchar(128)"`
	ProductName        *string  `json:"productname" gorm:"column:ProductName;type:nvarchar(255)"`
	Quantity           float64  `json:"quantity" gorm:"column:Quantity;type:numeric(18,3);not null"`
	Discount           *int     `json:"discount" gorm:"column:Discount"`
	Tax                *float32 `json:"tax" gorm:"column:Tax;type:real"`
	UnitPrice          float64  `json:"unitprice" gorm:"column:UnitPrice;type:decimal(19,4);not null"`
	PriceSale          *float64 `json:"pricesale" gorm:"column:PriceSale;type:decimal(19,4)"`
	QuantityPerUnit    *int     `json:"quantityperunit" gorm:"column:QuantityPerUnit"`
	Bultos             *int     `json:"bultos" gorm:"column:Bultos"`
	QuantityPerUnit2nd *int     `json:"quantityperunit2nd" gorm:"column:QuantityPerUnit2nd"`
	Bultos2nd          *int     `json:"bultos2nd" gorm:"column:Bultos2nd"`
	Fjson              string   `json:"fjson" gorm:"column:fjson;type:nvarchar(max)"`
	PriceFactory       *float64 `json:"pricefactory" gorm:"column:PriceFactory;type:decimal(19,4)"`
	Height             *float64 `json:"height" gorm:"column:height;type:float"`
	Length             *float64 `json:"length" gorm:"column:length;type:float"`
	Weight             *float64 `json:"weight" gorm:"column:weight;type:float"`
	Width              *float64 `json:"width" gorm:"column:width;type:float"`
	Option1            *int     `json:"option1" gorm:"column:Option1;default:0"`
	Action             *string  `json:"action" gorm:"column:Action;type:nvarchar(300)"`
	BatchCode          *string  `json:"batchcode" gorm:"column:BatchCode;type:nvarchar(128)"`
	Entrada            *float64 `json:"entrada" gorm:"column:Entrada;type:numeric(18,3)"`
}

func (pd *PurchaseDetails) TableName() string {
	return "Purchase Details"
}

// PurchaseDetailsWithProduct 采购详情与产品信息的联合查询结果
// 用于存储 PurchaseDetails 和 Products 表的联合查询结果
type PurchaseDetailsWithProduct struct {
	// PurchaseDetails 字段
	Id                 int      `json:"id" gorm:"primaryKey;autoIncrement;column:ID"`
	OrderId            *int     `json:"orderid" gorm:"column:OrderID"`
	ProductId          int      `json:"productid" gorm:"column:ProductID;not null"`
	UserCode           *string  `json:"usercode" gorm:"column:UserCode;type:nvarchar(128)"`
	BarCode            *string  `json:"barcode" gorm:"column:BarCode;type:nvarchar(128)"`
	ProductName        *string  `json:"productname" gorm:"column:ProductName;type:nvarchar(255)"`
	Quantity           float64  `json:"quantity" gorm:"column:Quantity;type:numeric(18,3);not null"`
	Discount           *int     `json:"discount" gorm:"column:Discount"`
	Tax                *float32 `json:"tax" gorm:"column:Tax;type:real"`
	UnitPrice          float64  `json:"unitprice" gorm:"column:UnitPrice;type:decimal(19,4);not null"`
	PriceSale          *float64 `json:"pricesale" gorm:"column:PriceSale;type:decimal(19,4)"`
	QuantityPerUnit    *int     `json:"quantityperunit" gorm:"column:QuantityPerUnit"`
	Bultos             *int     `json:"bultos" gorm:"column:Bultos"`
	QuantityPerUnit2nd *int     `json:"quantityperunit2nd" gorm:"column:QuantityPerUnit2nd"`
	Bultos2nd          *int     `json:"bultos2nd" gorm:"column:Bultos2nd"`
	Fjson              *string  `json:"fjson" gorm:"column:fjson;type:nvarchar(max)"`
	PriceFactory       *float64 `json:"pricefactory" gorm:"column:PriceFactory;type:decimal(19,4)"`
	Height             *float64 `json:"height" gorm:"column:height;type:float"`
	Length             *float64 `json:"length" gorm:"column:length;type:float"`
	Weight             *float64 `json:"weight" gorm:"column:weight;type:float"`
	Width              *float64 `json:"width" gorm:"column:width;type:float"`
	Option1            *int     `json:"option1" gorm:"column:Option1;default:0"`
	Action             *string  `json:"action" gorm:"column:Action;type:nvarchar(300)"`
	BatchCode          *string  `json:"batchcode" gorm:"column:BatchCode;type:nvarchar(128)"`
	Entrada            float64  `json:"entrada" gorm:"column:Entrada;type:numeric(18,3)"`

	// Products 表字段
	PricePurchase float64  `json:"pricepurchase" gorm:"column:pricepurchase"`
	PdUnitPrice   float64  `json:"pdunitprice" gorm:"column:pdunitprice"`
	UnitPrice4    *float64 `json:"unitprice4" gorm:"column:unitprice4"`
}

func (pdwp *PurchaseDetailsWithProduct) TableName() string {
	return "PurchaseDetails"
}

// PurchaseDetailsWithProductAndSupplier 采购详情与产品信息和供应商信息的联合查询结果
// 用于存储 PurchaseDetails、Products 和 Suppliers 表的联合查询结果
type PurchaseDetailsWithProductAndSupplier struct {
	// PurchaseDetails 字段
	Id                 int      `json:"id" gorm:"primaryKey;autoIncrement;column:ID"`
	OrderId            *int     `json:"orderid" gorm:"column:OrderID"`
	ProductId          int      `json:"productid" gorm:"column:ProductID;not null"`
	UserCode           *string  `json:"usercode" gorm:"column:UserCode;type:nvarchar(128)"`
	BarCode            *string  `json:"barcode" gorm:"column:BarCode;type:nvarchar(128)"`
	ProductName        *string  `json:"productname" gorm:"column:ProductName;type:nvarchar(255)"`
	Quantity           float64  `json:"quantity" gorm:"column:Quantity;type:numeric(18,3);not null"`
	Discount           *int     `json:"discount" gorm:"column:Discount"`
	Tax                *float32 `json:"tax" gorm:"column:Tax;type:real"`
	UnitPrice          float64  `json:"unitprice" gorm:"column:UnitPrice;type:decimal(19,4);not null"`
	PriceSale          *float64 `json:"pricesale" gorm:"column:PriceSale;type:decimal(19,4)"`
	QuantityPerUnit    *int     `json:"quantityperunit" gorm:"column:QuantityPerUnit"`
	Bultos             *int     `json:"bultos" gorm:"column:Bultos"`
	QuantityPerUnit2nd *int     `json:"quantityperunit2nd" gorm:"column:QuantityPerUnit2nd"`
	Bultos2nd          *int     `json:"bultos2nd" gorm:"column:Bultos2nd"`
	Fjson              *string  `json:"fjson" gorm:"column:fjson;type:nvarchar(max)"`
	PriceFactory       *float64 `json:"pricefactory" gorm:"column:PriceFactory;type:decimal(19,4)"`
	Height             *float64 `json:"height" gorm:"column:height;type:float"`
	Length             *float64 `json:"length" gorm:"column:length;type:float"`
	Weight             *float64 `json:"weight" gorm:"column:weight;type:float"`
	Width              *float64 `json:"width" gorm:"column:width;type:float"`
	Option1            *int     `json:"option1" gorm:"column:Option1;default:0"`
	Action             *string  `json:"action" gorm:"column:Action;type:nvarchar(300)"`
	BatchCode          *string  `json:"batchcode" gorm:"column:BatchCode;type:nvarchar(128)"`
	Entrada            float64  `json:"entrada" gorm:"column:Entrada;type:numeric(18,3)"`

	// Products 表字段
	PricePurchase float64  `json:"pricepurchase" gorm:"column:pricepurchase"`
	PdUnitPrice   float64  `json:"pdunitprice" gorm:"column:pdunitprice"`
	UnitPrice4    *float64 `json:"unitprice4" gorm:"column:unitprice4"`

	// Suppliers 表字段
	SupplierCompanyName *string `json:"supplierCompanyName" gorm:"column:SupplierCompanyName"` // 供应商公司名称
}

func (pdwps *PurchaseDetailsWithProductAndSupplier) TableName() string {
	return "PurchaseDetails"
}
