package models

type UpdateEntradaRequest struct {
	Id           string  `json:"id"`
	BarCode      string  `json:"barCode"`
	Entrada      string  `json:"entrada"`
	UnitPrice    string  `json:"unitPrice"`
	ProductId    int     `json:"productId"`
	OrderId      string  `json:"orderId"`
	Remark       string  `json:"remark"`
	SubTotal     float64 `json:"subTotal"`
	UnitsInStock float64 `json:"unitsInStock"`
}

type UpdateProductUnitPrice struct {
	ProductId string `json:"productId"`
	UnitPrice string `json:"unitPrice"`
}

type UpdateRemark struct {
	OrderId string `json:"orderId"`
	Remark  string `json:"remark"`
}

type UpdateQuantity struct {
	OrderId string `json:"orderId"`
}

type ExcelData struct {
	UserCode      string   `json:"userCode"`      // Referencia - 编码
	Barcode       string   `json:"barcode"`       // Código - 条码
	ProductName   string   `json:"productName"`   // Articulo - 商品名称
	ProductName2  string   `json:"productName2"`  // Nombre2 - 商品名称2
	Lote          string   `json:"lote"`          // Lote - 批次
	Quantity      string   `json:"quantity"`      // Cantidad - 数量
	UnitPrice     string   `json:"unitPrice"`     // Precio - 单价（进货价）
	Discount      string   `json:"discount"`      // Dto% - 折扣
	Tax           string   `json:"tax"`           // IVA - 税率
	FinalPrice    string   `json:"finalPrice"`    // Precio Final - 折后价
	SubTotal      string   `json:"subTotal"`      // Subtotal - 合计
	PricePurchase *float64 `json:"pricePurchase"` // 销售价（不在 Excel 中）
	ImgPath       string   `json:"imgPath"`       // 图片地址（不在 Excel 中）
	MinY          float64  `json:"minY"`          // 位置（不在 Excel 中）
	MaxY          float64  `json:"maxY"`          // 位置（不在 Excel 中）
	PageIndex     int      `json:"pageIndex"`     // 页码（不在 Excel 中）
}

type ExcelDataRequest struct {
	UserCode      string `json:"userCode"`      // Referencia - 编码
	Barcode       string `json:"barcode"`       // Código - 条码
	ProductName   string `json:"productName"`   // Articulo - 商品名称
	ProductName2  string `json:"productName2"`  // Articulo - 商品名称中文
	Quantity      string `json:"quantity"`      // Cantidad - 数量
	UnitPrice     string `json:"unitPrice"`     // Precio - 单价（进货价）
	Discount      string `json:"discount"`      // Dto% - 折扣
	FinalPrice    string `json:"finalPrice"`    // Precio Final - 折后价
	SubTotal      string `json:"subTotal"`      // Subtotal - 合计
	PricePurchase string `json:"pricePurchase"` // 销售价（不在 Excel 中）
	ImgPath       string `json:"imgPath"`       // 图片地址（不在 Excel 中）
	Tax           string `json:"tax"`           // IVA - 税率
}

// ReturnGoodsRequest 退货请求结构体
// 用于处理单个商品的退货请求
type ReturnGoodsRequest struct {
	ProductId  int     `json:"productId" binding:"required"`     // 商品ID
	Quantity   float64 `json:"quantity" binding:"required,gt=0"` // 退货数量
	UnitPrice  float64 `json:"unitPrice" binding:"required"`     // 退货单价
	OrderId    int     `json:"orderId" binding:"required"`       // 原订单ID
	Remark     string  `json:"remark"`                           // 退货备注
	SupplierId int     `json:"supplierId" binding:"required"`    // 供应商ID
	EmployeeId int     `json:"employeeId" binding:"required"`    // 员工ID
}

// SubmitReturnGoodsRequest 提交退货单请求结构体
// 新的接口参数结构
type SubmitReturnGoodsRequest struct {
	ArticuloList []ArticuloItem `json:"articuloList" binding:"required"` // 商品列表
	EmpresaId    string         `json:"empresaId" binding:"required"`    // 供应商ID
}

// ReturnGoodsResponse 退货响应结构体
type ReturnGoodsResponse struct {
	ReturnOrderId int     `json:"returnOrderId"` // 退货单ID
	SubTotal      float64 `json:"subTotal"`      // 退货小计（负数）
	Message       string  `json:"message"`       // 响应消息
}

// ArticuloItem 商品项结构体
type ArticuloItem struct {
	Amount float64 `json:"amount"` // 数量
	Nombre string  `json:"nombre"` // 商品名称
	Precio float64 `json:"precio"` // 价格
	Type   int     `json:"type"`   // 类型
	Value  string  `json:"value"`  // 商品ID
}

// AddReturnedArticuloRequest 添加退货商品请求结构体
type AddReturnedArticuloRequest struct {
	ArticuloList []ArticuloItem `json:"articuloList"` // 商品列表
	EmpresaId    string         `json:"empresaId"`    // 企业ID
}

// BloqueadoRequest 审核状态更新请求结构体
type BloqueadoRequest struct {
	DocumentoNo string `form:"documentoNo" binding:"required"` // 退货单号
	Bloqueado   string `form:"bloqueado" binding:"required"`   // 审核状态
}

// DeleteReturnedArticuloRequest 删除退货商品请求结构体
type DeleteReturnedArticuloRequest struct {
	DocumentoNo string `form:"documentoNo" binding:"required"` // 退货单号
}

// UpdateReturnedArticuloRequest 更新退货商品请求结构体
type UpdateReturnedArticuloRequest struct {
	Amount      string `form:"amount" binding:"required"`      // 商品数量
	Precio      string `form:"precio" binding:"required"`      // 进价
	Code        string `form:"code" binding:"required"`        // 商品ID
	DocumentoNo string `form:"documentoNo" binding:"required"` // 退货单号
}
