package models

import "time"

// Suppliers 供应商模型
// 对应数据库中的Suppliers表，包含供应商的所有属性信息
type Suppliers struct {
	SupplierId           int       `json:"supplierid" gorm:"primaryKey;autoIncrement;column:SupplierID"`
	Address              *string   `json:"address" gorm:"column:Address;type:nvarchar(255)"`
	AddressNumber        *string   `json:"addressnumber" gorm:"column:AddressNumber;type:nvarchar(50)"`
	City                 *string   `json:"city" gorm:"column:City;type:nvarchar(50)"`
	CompanyName          *string   `json:"companyname" gorm:"column:CompanyName;type:nvarchar(255)"`
	ConsumerOnOrder      *float64  `json:"consumeronorder" gorm:"column:ConsumerOnOrder;type:decimal(19,4)"`
	ConsumerOnPurchase   *float64  `json:"consumeronpurchase" gorm:"column:ConsumerOnPurchase;type:decimal(19,4)"`
	ContactName          *string   `json:"contactname" gorm:"column:ContactName;type:nvarchar(255)"`
	Discount             *float32  `json:"discount" gorm:"column:Discount;type:real"`
	EnableProductsBatch  *bool     `json:"enableproductsbatch" gorm:"column:EnableProductsBatch;type:bit"`
	Fax                  *string   `json:"fax" gorm:"column:Fax;type:nvarchar(24)"`
	Fjson                *string   `json:"fjson" gorm:"column:fjson;type:nvarchar(max)"`
	Hide                 *bool     `json:"hide" gorm:"column:hide;type:bit"`
	HomePage             *string   `json:"homepage" gorm:"column:HomePage;type:nvarchar(max)"`
	InitCode             *int      `json:"initcode" gorm:"column:InitCode"`
	LastPurchaseDate     *time.Time `json:"lastpurchasedate" gorm:"column:LastPurchaseDate;type:datetime"`
	PayDays              *int      `json:"paydays" gorm:"column:PayDays"`
	Phone                *string   `json:"phone" gorm:"column:Phone;type:nvarchar(24)"`
	Picture              *string   `json:"picture" gorm:"column:Picture;type:nvarchar(max)"`
	PostalCode           *string   `json:"postalcode" gorm:"column:PostalCode;type:nvarchar(10)"`
	Prepaid              *float64  `json:"prepaid" gorm:"column:Prepaid;type:decimal(19,4)"`
	Region               *string   `json:"region" gorm:"column:Region;type:nvarchar(50)"`
	Remark               *string   `json:"remark" gorm:"column:Remark;type:nvarchar(max)"`
	Size                 *float64  `json:"size" gorm:"column:size;type:float;default:0"`
}

func (s *Suppliers) TableName() string {
	return "Suppliers"
}