package v1

import (
	"github.com/gogf/gf/v2/frame/g"
)

type TiemInfo struct {
	Productid     string `json:"productid"`
	Barcode       string `json:"barcode"`
	Productname   string `json:"productname"`
	Productname2  string `json:"productname2"`
	Pricepurchase string `json:"pricepurchase"`
	Unitprice     string `json:"unitprice"`
	Unitprice2    string `json:"unitprice2"`
	Categoryid    string `json:"categoryid"`
	Supplierid    string `json:"supplierid"`
	Unitsinstock  string `json:"unitsinstock"`
	Discount      string `json:"discount"`
	Tax           string `json:"tax"`
	Companyname   string `json:"companyname"`
	Observacion   string `json:"observacion"`
}

type ScanReq struct {
	g.Meta   `path:"/articulo/scan" tags:"t_item_info" method:"post,get" summary:"查询商品信息"`
	Usercode string `json:"usercode" dc:"商品编码，条码 tm，sxx"`
}
type ScanRes map[string]any

// type ScanRes struct {
// 	TItemInfo    *entity.TItemInfo   `json:"tItemInfo" dc:"商品信息"`
// 	StorageCount int                 `json:"storageCount" dc:"库存"`
// 	TItemLb      *entity.TItemLb     `json:"tItemLb" dc:"类别"`
// 	TSysSupInfo  *entity.TSysSupInfo `json:"tSysSupInfo" dc:"供货商"`
// }

type UpdateReq struct {
	g.Meta `path:"/articulo/update" tags:"t_item_info" method:"post,get" summary:"更新添加商品信息"`
	TiemInfo
}

type UpdateRes struct {
}

type AddReq struct {
	g.Meta `path:"/articulo/add" tags:"t_item_info" method:"post,get" summary:"添加商品信息"`
	TiemInfo
}

type AddRes struct {
}
