package cmd

import (
	"context"

	"github.com/gogf/gf/v2/errors/gcode"
	"github.com/gogf/gf/v2/errors/gerror"
	"github.com/gogf/gf/v2/frame/g"
	"github.com/gogf/gf/v2/net/ghttp"
	"github.com/gogf/gf/v2/os/gcmd"

	"tongchuang/internal/controller/hello"
	"tongchuang/internal/controller/t_item_info"
	"tongchuang/internal/controller/t_item_lb"
	"tongchuang/internal/controller/t_sys_sup_info"
)

var (
	Main = gcmd.Command{
		Name:  "main",
		Usage: "main",
		Brief: "start http server",
		Func: func(ctx context.Context, parser *gcmd.Parser) (err error) {

			s := g.Server()
			s.Group("/", func(group *ghttp.RouterGroup) {
				group.Middleware(ghttp.MiddlewareHandlerResponse)
				group.Middleware(MiddlewareResponse200)
				group.Bind(
					hello.NewV1(),
					t_item_info.NewV1(),
					t_item_lb.NewV1(),
					t_sys_sup_info.NewV1(),
				)
			})

			s.Run()

			return nil
		},
	}
)

func MiddlewareResponse200(r *ghttp.Request) {
	r.Middleware.Next()

	if r.Response.BufferLength() > 0 || r.Response.BytesWritten() > 0 {
		return
	}

	err := r.GetError()
	res := r.GetHandlerResponse()

	if err != nil {
		code := gerror.Code(err)
		if code == gcode.CodeNil {
			code = gcode.CodeInternalError
		}

		r.Response.WriteJson(g.Map{
			"code":    code.Code(),
			"message": err.Error(),
			"data":    nil,
		})
		return
	}

	// ✅ 成功统一 200
	r.Response.WriteJson(g.Map{
		"code":    200,
		"message": "OK",
		"data":    res,
	})
}
