package t_item_info

import (
	"context"
	"fmt"

	v1 "tongchuang/api/t_item_info/v1"
	"tongchuang/internal/service"

	"github.com/gogf/gf/v2/util/gconv"
)

func (c *ControllerV1) Scan(ctx context.Context, req *v1.ScanReq) (res *v1.ScanRes, err error) {
	res = &v1.ScanRes{}

	tiemInfo, storageNumber, tiemLb, supInfo, err := service.TItemInfo().Scan(ctx, req.Usercode)
	if err != nil || tiemInfo == nil {
		return nil, err
	}

	fmt.Println(tiemInfo, storageNumber, tiemLb, supInfo)

	s := &v1.TiemInfo{
		Productid:     gconv.String(tiemInfo.Sxx),
		Barcode:       gconv.String(tiemInfo.Tm),
		Productname:   gconv.String(tiemInfo.Na),
		Productname2:  gconv.String(tiemInfo.Pyjc),
		Pricepurchase: gconv.String(tiemInfo.Jj),
		Unitprice:     gconv.String(tiemInfo.Lsj),
		Unitprice2:    gconv.String(tiemInfo.Bp),
		Categoryid:    gconv.String(tiemInfo.Dl),
		Supplierid:    gconv.String(tiemInfo.Hs),
		Unitsinstock:  gconv.String(storageNumber),
		Discount:      gconv.String(tiemInfo.Qtzkl),
		Tax:           gconv.String(tiemInfo.Tr),
		Companyname:   gconv.String(supInfo.Mc),
		// Observacion:   gconv.String(tiemInfo.), //备注

	}

	resMap := gconv.Map(s)
	resMap["usercode"] = gconv.String(tiemInfo.Sxx)

	*res = resMap

	return res, nil
}
