package t_item_info

import (
	"context"
	"errors"

	v1 "tongchuang/api/t_item_info/v1"
	"tongchuang/internal/model/entity"
	"tongchuang/internal/service"

	"github.com/gogf/gf/v2/util/gconv"
)

func (c *ControllerV1) Update(ctx context.Context, req *v1.UpdateReq) (res *v1.UpdateRes, err error) {
	res = &v1.UpdateRes{}
	if gconv.Int(req.TiemInfo.Productid) == 0 {
		return nil, errors.New("Productid is 0")
	}

	d := &entity.TItemInfo{
		Sxx:  gconv.Int(req.TiemInfo.Productid),
		Tm:   req.TiemInfo.Barcode,
		Na:   req.TiemInfo.Productname,
		Pyjc: req.TiemInfo.Productname2,
		Jj:   gconv.Float64(req.TiemInfo.Pricepurchase),
		Lsj:  gconv.Float64(req.TiemInfo.Unitprice),
		Bp:   gconv.Float64(req.TiemInfo.Unitprice2),
		Dl:   gconv.Int(req.TiemInfo.Categoryid),
		Hs:   gconv.Int(req.TiemInfo.Supplierid),
		//库存？？？
		Qtzkl: gconv.Float64(req.TiemInfo.Discount),
		Tr:    gconv.Float64(req.TiemInfo.Tax),
		//供应商名称
		// req.TiemInfo.Observacion 备注
	}

	//库存
	ts := &entity.TItemStorage{
		Ks: gconv.Int(req.TiemInfo.Productid),
		Yl: gconv.Float64(req.TiemInfo.Unitsinstock),
	}

	err = service.TItemInfo().AE(ctx, d, ts)
	return nil, err
}
