package t_item_lb

import (
	"context"

	v1 "tongchuang/api/t_item_lb/v1"
	"tongchuang/internal/service"

	"github.com/gogf/gf/v2/util/gconv"
)

func (c *ControllerV1) GetClass(ctx context.Context, req *v1.GetClassReq) (res *v1.GetClassRes, err error) {
	res = &v1.GetClassRes{}
	data, err := service.TItemLb().GetAll(ctx)
	if err != nil {
		return nil, err
	}

	for _, v := range data {
		*res = append(*res, v1.Category{
			Categoryid:   gconv.String(v.Lb),
			Categoryname: v.Lqm,
		})
	}

	return
}
