package t_sys_sup_info

import (
	"context"

	v1 "tongchuang/api/t_sys_sup_info/v1"
	"tongchuang/internal/service"

	"github.com/gogf/gf/v2/util/gconv"
)

func (c *ControllerV1) GetSupplier(ctx context.Context, req *v1.GetSupplierReq) (res *v1.GetSupplierRes, err error) {
	res = &v1.GetSupplierRes{}
	data, err := service.TSysSupInfo().GetAll(ctx)
	if err != nil {
		return nil, err
	}

	for _, v := range data {
		*res = append(*res, v1.Supplier{
			Supplierid:  gconv.String(v.Bx),
			Companyname: v.Mc,
		})
	}

	return

}
