// =================================================================================
// This file is auto-generated by the GoFrame CLI tool.You may modify it as needed.
// =================================================================================

package dao

import (
	"context"
	"tongchuang/internal/dao/internal"
	"tongchuang/internal/model/entity"

	"github.com/gogf/gf/v2/frame/g"
	"github.com/gogf/gf/v2/os/gtime"
)

// tItemInfoDao is the data access object for the table t_item_info.
// You can define custom methods on it to extend its functionality as needed.
type tItemInfoDao struct {
	*internal.TItemInfoDao
}

var (
	// TItemInfo is a globally accessible object for table t_item_info operations.
	TItemInfo = tItemInfoDao{internal.NewTItemInfoDao()}
)

// Add your custom methods and functionality below.

// GetByUsercode 查询编码或条码
func (d *tItemInfoDao) GetByUsercode(ctx context.Context, usercode string) (result *entity.TItemInfo, err error) {
	//为什么要加.Fields("*") 因为框架自动把#字段过滤了！
	err = d.Ctx(ctx).Fields("*").Where(d.Columns().Tm, usercode).WhereOr("sx# = ?", usercode).Scan(&result)
	return
}

// GetByUsercode 查询编码或条码 排除sx#
func (d *tItemInfoDao) GetByUsercodeNotSxx(ctx context.Context, usercode, notSx string) (result *entity.TItemInfo, err error) {
	//为什么要加.Fields("*") 因为框架自动把#字段过滤了！
	err = d.Ctx(ctx).Fields("*").WhereNot(d.Columns().Sxx, notSx).Where(
		d.Ctx(ctx).Builder().Where(d.Columns().Tm, usercode).WhereOr("sx# = ?", usercode),
	).Scan(&result)
	return
}

func (d *tItemInfoDao) Update(ctx context.Context, itemInfo *entity.TItemInfo) (err error) {
	itemInfo.Zjt = gtime.Now()
	itemInfo.Xgt = nil
	_, err = d.Ctx(ctx).FieldsEx("sx#").Where("sx# = ?", itemInfo.Sxx).OmitEmpty().Update(itemInfo)
	return
}

func (d *tItemInfoDao) Add(ctx context.Context, itemInfo *entity.TItemInfo) (err error) {
	var result *entity.TItemInfo
	err = d.Ctx(ctx).Fields("*").OrderDesc(d.Columns().Sxx).Scan(&result)
	if err != nil {
		return
	}

	timeNow := gtime.Now()
	// 这种方式不会被驱动自动添加 OUTPUT 子句
	//条码，名称，类别编号，进价，售价，税率，批发价，供应商编号，名称大写，折扣，1，1，创建时间，修改时间
	sql := "INSERT INTO t_item_info (sx#,tm,na,dl,jj,lsj,tr,bp,hs,pyjc,qtzkl,gsp_valid_date,other4,zjt,xgt,    z0,zl,xl,hz,dj,xb,xg,thh,up,sx,xx,ry,bzt,gdj,bdj,htj,ddh,yj,bt) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,   0,0,0,1,0,1,1,1,0,0,0,0,0,2,0,0,0,0,0)"
	_, err = g.DB().Raw(sql,
		result.Sxx+1,
		itemInfo.Tm, itemInfo.Na, itemInfo.Dl, itemInfo.Jj, itemInfo.Lsj, itemInfo.Tr, itemInfo.Bp, itemInfo.Hs, itemInfo.Pyjc, itemInfo.Qtzkl, 1, 1, timeNow, timeNow,
	).All()
	itemInfo.Sxx = result.Sxx + 1

	return
}
