// =================================================================================
// This file is auto-generated by the GoFrame CLI tool. You may modify it as needed.
// =================================================================================

package dao

import (
	"context"
	"tongchuang/internal/dao/internal"
	"tongchuang/internal/model/entity"

	"github.com/gogf/gf/v2/frame/g"
	"github.com/gogf/gf/v2/os/gtime"
)

// tItemStorageDao is the data access object for the table t_item_storage.
// You can define custom methods on it to extend its functionality as needed.
type tItemStorageDao struct {
	*internal.TItemStorageDao
}

var (
	// TItemStorage is a globally accessible object for table t_item_storage operations.
	TItemStorage = tItemStorageDao{internal.NewTItemStorageDao()}
)

// Add your custom methods and functionality below.

// GetCountBySn 查询库存
func (d *tItemStorageDao) GetStockByKs(ctx context.Context, ks int) (result *entity.TItemStorage, err error) {
	err = d.Ctx(ctx).Where("ks# = ?", ks).Scan(&result)
	return
}

func (d *tItemStorageDao) Add(ctx context.Context, data *entity.TItemStorage) (err error) {
	timeNow := gtime.Now()
	// 这种方式不会被驱动自动添加 OUTPUT 子句
	sql := "INSERT INTO t_item_storage(sn#,kbm,kgz,yl,ks#,ycl,byr,byx,byd,dtMaxChanged) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?)"
	_, err = g.DB().Raw(sql,
		1, 1, 1, data.Yl, data.Ks, 0, 0, 0, 0,
		timeNow,
	).All()

	return
}

func (d *tItemStorageDao) Update(ctx context.Context, data *entity.TItemStorage) (err error) {
	data.DtMaxChanged = gtime.Now()
	_, err = d.Ctx(ctx).Fields("yl,dtMaxChanged").Where("ks# = ?", data.Ks).Update(data)
	return
}
