package t_item_info

import (
	"context"
	"errors"
	"tongchuang/internal/dao"
	"tongchuang/internal/model/entity"
	"tongchuang/internal/service"

	"github.com/gogf/gf/v2/util/gconv"
)

type sTItemInfo struct {
}

func init() {
	service.RegisterTItemInfo(New1())

}

func New1() *sTItemInfo {
	return &sTItemInfo{}
}

// Scan 查询商品信息
func (s *sTItemInfo) Scan(ctx context.Context, usercode string) (
	tiemInfo *entity.TItemInfo,
	storageCount int,
	tiemLb *entity.TItemLb,
	supInfo *entity.TSysSupInfo,
	err error,
) {
	//查询商品
	tiemInfo, err = dao.TItemInfo.GetByUsercode(ctx, usercode)
	if err != nil {
		return
	}
	if tiemInfo == nil {
		return
	}

	//查询库存
	var tItemStorage *entity.TItemStorage
	tItemStorage, err = dao.TItemStorage.GetStockByKs(ctx, tiemInfo.Sxx)
	if err != nil {
		return
	}
	if tItemStorage == nil {
		storageCount = 0
	} else {
		storageCount = int(tItemStorage.Yl)
	}

	//查询类别
	tiemLb, err = dao.TItemLb.GetByLb(ctx, tiemInfo.Dl)
	if err != nil {
		return
	}

	//查询供应商
	supInfo, err = dao.TSysSupInfo.GetByBx(ctx, tiemInfo.Hs)
	if err != nil {
		return
	}

	return
}

// Update 查询商品信息
func (s *sTItemInfo) AE(ctx context.Context, itemInfo *entity.TItemInfo, itemStorage *entity.TItemStorage) (err error) {

	if itemInfo.Sxx != 0 {
		itemInfo1, err := dao.TItemInfo.GetByUsercodeNotSxx(ctx, gconv.String(itemInfo.Sxx), gconv.String(itemInfo.Sxx))
		if err != nil {
			return err
		}
		if itemInfo1 != nil {
			err = errors.New("商品编码已经存在！")
		}

		itemInfo2, err := dao.TItemInfo.GetByUsercodeNotSxx(ctx, gconv.String(itemInfo.Tm), gconv.String(itemInfo.Sxx))
		if err != nil {
			return err
		}

		if itemInfo2 != nil {
			err = errors.New("商品条码已经存在！")
			return err
		}
		err = dao.TItemInfo.Update(ctx, itemInfo)
		if err != nil {
			return err
		}

		err = dao.TItemStorage.Update(ctx, itemStorage)
		if err != nil {
			return err
		}
		return err

	}

	itemInfo1, err := dao.TItemInfo.GetByUsercode(ctx, gconv.String(itemInfo.Sxx))
	if err != nil {
		return
	}
	if itemInfo1 != nil {
		err = errors.New("商品编码已经存在！")
	}

	itemInfo2, err := dao.TItemInfo.GetByUsercode(ctx, gconv.String(itemInfo.Tm))
	if err != nil {
		return
	}

	if itemInfo2 != nil {
		err = errors.New("商品条码已经存在！")
		return
	}

	err = dao.TItemInfo.Add(ctx, itemInfo)
	if err != nil {
		return
	}
	if itemStorage.Ks == 0 {
		itemStorage.Ks = itemInfo.Sxx
	}

	err = dao.TItemStorage.Add(ctx, itemStorage)
	if err != nil {
		return
	}
	return err
}
