# 图片上传接口文档

## 接口概述

本接口用于处理商品图片的base64格式上传，支持将base64编码的图片数据保存到服务器指定目录。

## 接口信息

- **URL**: `/image/upload`
- **方法**: `POST`
- **Content-Type**: `application/json`

## 请求参数

| 参数名 | 类型 | 必填 | 说明 |
|--------|------|------|------|
| articuloID | string | 是 | 商品ID，用于生成文件名 |
| dibujo | string | 是 | base64编码的图片数据 |

## 请求示例

```json
{
    "articuloID": "PROD001",
    "dibujo": "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mNkYPhfDwAChwGA60e6kgAAAABJRU5ErkJggg=="
}
```

## 响应格式

### 成功响应 (200)

```json
{
    "code": "200",
    "message": "图片上传成功",
    "data": {
        "filePath": "image/PROD001.jpg",
        "success": true,
        "message": "图片上传成功"
    }
}
```

### 错误响应

#### 400 - 请求参数错误
```json
{
    "code": "400",
    "message": "请求体格式错误",
    "data": null
}
```

#### 500 - 服务器内部错误
```json
{
    "code": "500",
    "message": "图片上传失败: 具体错误信息",
    "data": null
}
```

## 文件存储规则

- 图片文件保存在 `image/` 目录下
- 文件命名格式：`{articuloID}.jpg`
- 如果目录不存在，会自动创建
- 文件权限设置为 0644

## 使用示例

### cURL 示例

```bash
curl -X POST http://localhost:8080/image/upload \
  -H "Content-Type: application/json" \
  -d '{
    "articuloID": "PROD001",
    "dibujo": "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mNkYPhfDwAChwGA60e6kgAAAABJRU5ErkJggg=="
  }'
```