package controller

import (
	"github.com/gin-gonic/gin"
	"net/http"
	"supermarket-go/internal/service"
)

type DuihuoController struct {
	AlbaranproveedorService         *service.AlbaranproveedorService
	AlbaranproveedorarticuloService *service.AlbaranproveedorarticuloService
}

func RegisterDuihuoRoutes(r *gin.Engine, albSvc *service.AlbaranproveedorService, albArtSvc *service.AlbaranproveedorarticuloService) {
	ctrl := &DuihuoController{AlbaranproveedorService: albSvc, AlbaranproveedorarticuloService: albArtSvc}
	g := r.Group("/Scem")
	{
		g.GET("/dy_dz_order", ctrl.DyDzOrder)
		g.GET("/dy_dz_order_info2", ctrl.DyDzOrderInfo2)
		g.GET("/dy_dz_order_info", ctrl.DyDzOrderInfo)
		g.GET("/dy_dz_order_edit", ctrl.DyDzOrderEdit)
		g.GET("/dy_dz_order_status", ctrl.DyDzOrderStatus)
		g.GET("/dy_dz_order_jiaodui", ctrl.DyDzOrderJiaodui)
	}
}

func (ctrl *DuihuoController) DyDzOrder(c *gin.Context) {
	code := c.DefaultQuery("code", "")
	bloqueado := c.DefaultQuery("Bloqueado", "")

	result := ctrl.AlbaranproveedorService.DyDzOrder(code, bloqueado)
	c.JSON(http.StatusOK, buildResponse("200", "success", result))
}

func (ctrl *DuihuoController) DyDzOrderInfo2(c *gin.Context) {
	code := c.Query("code")
	articuloID := c.Query("ArticuloID")

	if code == "" || articuloID == "" {
		c.JSON(http.StatusBadRequest, buildResponse("400", "参数不完整", nil))
		return
	}

	result := ctrl.AlbaranproveedorarticuloService.QueryOne(code, articuloID)
	c.JSON(http.StatusOK, buildResponse("200", "success", result))
}

func (ctrl *DuihuoController) DyDzOrderInfo(c *gin.Context) {
	code := c.Query("code")
	articuloID := c.DefaultQuery("ArticuloID", "")
	bloqueado := c.Query("Bloqueado")

	if code == "" || bloqueado == "" {
		c.JSON(http.StatusBadRequest, map[string]interface{}{
			"code":    "400",
			"data":    nil,
			"message": "参数不完整",
		})
		return
	}

	result := ctrl.AlbaranproveedorarticuloService.QueryList(code, articuloID, bloqueado)
	c.JSON(http.StatusOK, map[string]interface{}{
		"code":    "200",
		"data":    result,
		"message": "",
	})
}

func (ctrl *DuihuoController) DyDzOrderEdit(c *gin.Context) {
	articuloID := c.Query("ArticuloID")
	precio := c.Query("Precio")
	precioDetalle := c.Query("PrecioDetalle")
	comentario := c.Query("Comentario")
	comentarioMax := c.Query("ComentarioMax")

	if articuloID == "" {
		c.JSON(http.StatusBadRequest, buildResponse("400", "ArticuloID不能为空", nil))
		return
	}

	result := ctrl.AlbaranproveedorarticuloService.UpdateOne(articuloID, precio, precioDetalle, comentario, comentarioMax)
	//if result == 0 {
	//	c.JSON(http.StatusInternalServerError, buildResponse("500", "更新失败", nil))
	//	return
	//}

	c.JSON(http.StatusOK, buildResponse("200", "更新成功", result))
}

func (ctrl *DuihuoController) DyDzOrderStatus(c *gin.Context) {
	code := c.Query("code")
	bloqueado := c.Query("Bloqueado")

	if code == "" || bloqueado == "" {
		c.JSON(http.StatusBadRequest, buildResponse("400", "参数不完整", nil))
		return
	}

	// 先查询单据是否存在
	albaranproveedor := ctrl.AlbaranproveedorService.QueryByAlbaranProveedorNo(code)
	if albaranproveedor == nil {
		c.JSON(http.StatusInternalServerError, buildResponse("500", "单据不存在", ""))
		return
	}

	result := ctrl.AlbaranproveedorarticuloService.DyDzOrderStatus(code, bloqueado)
	c.JSON(http.StatusOK, buildResponse("200", "success", result))
}

func (ctrl *DuihuoController) DyDzOrderJiaodui(c *gin.Context) {
	code := c.Query("code")

	if code == "" {
		c.JSON(http.StatusBadRequest, buildResponse("400", "code参数不能为空", nil))
		return
	}

	// 先查询单据是否存在
	albaranproveedor := ctrl.AlbaranproveedorService.QueryByAlbaranProveedorNo(code)
	if albaranproveedor == nil {
		c.JSON(http.StatusInternalServerError, buildResponse("500", "单据不存在", ""))
		return
	}

	result := ctrl.AlbaranproveedorarticuloService.DyDzOrderJiaodui(code)
	c.JSON(http.StatusOK, buildResponse("200", "校对完成", result))
}
