package model

import "time"

type Proveedor struct {
	EmpresaID             uint64     `gorm:"primaryKey;column:EmpresaID"`
	NombreES              string     `gorm:"column:NombreES;size:60;not null;default:''"`
	NombreCN              string     `gorm:"column:NombreCN;size:60;not null;default:''"`
	CIF                   string     `gorm:"column:CIF;size:60;not null;default:''"`
	NumeroIVA             string     `gorm:"column:NumeroIVA;size:30;not null;default:''"`
	Domicilio             string     `gorm:"column:Domicilio;size:120;not null;default:''"`
	CodigoPostal          string     `gorm:"column:CodigoPostal;size:20;not null;default:''"`
	Poblacion             string     `gorm:"column:Poblacion;size:60;not null;default:''"`
	Provincia             string     `gorm:"column:Provincia;size:60;not null;default:''"`
	Pais                  string     `gorm:"column:Pais;size:60;not null;default:''"`
	CountryID             string     `gorm:"column:CountryID;size:2;not null;default:''"`
	PersonaContacto       string     `gorm:"column:PersonaContacto;size:60;not null;default:''"`
	Sexo                  uint16     `gorm:"column:Sexo;not null;default:0"`
	Cumpleano             *time.Time `gorm:"column:Cumpleano"`
	Telefono              string     `gorm:"column:Telefono;size:40;not null;default:''"`
	Telefono2             string     `gorm:"column:Telefono2;size:40;not null;default:''"`
	Fax                   string     `gorm:"column:Fax;size:40;not null;default:''"`
	Email                 string     `gorm:"column:Email;size:60;not null;default:''"`
	Web                   string     `gorm:"column:Web;size:60;not null;default:''"`
	IM                    string     `gorm:"column:IM;size:40;not null;default:''"`
	IVAClase              uint8      `gorm:"column:IVAClase;not null;default:0"`
	ReglaIVA              uint8      `gorm:"column:ReglaIVA;not null;default:0"`
	FacturaPorcentaje     float64    `gorm:"column:FacturaPorcentaje;type:decimal(5,2);not null;default:0.00"`
	FacturaDescuento      float64    `gorm:"column:FacturaDescuento;type:decimal(5,2);not null;default:0.00"`
	FacturaSDIID          string     `gorm:"column:FacturaSDIID;size:40;not null;default:''"`
	FacturaCEC            string     `gorm:"column:FacturaCEC;size:60;not null;default:''"`
	BancoCuentaNo         string     `gorm:"column:BancoCuentaNo;size:200;not null;default:''"`
	NecesitaFactura       bool       `gorm:"column:NecesitaFactura;not null;default:0"`
	AutoEmailDocumento    bool       `gorm:"column:AutoEmailDocumento;not null;default:0"`
	Descuento             float64    `gorm:"column:Descuento;type:decimal(5,2);not null;default:0.00"`
	DescuentoSerie        int8       `gorm:"column:DescuentoSerie;not null;default:0"`
	DescuentoExtra        float64    `gorm:"column:DescuentoExtra;type:decimal(5,2);not null;default:0.00"`
	MaxSobregiro          float64    `gorm:"column:MaxSobregiro;type:decimal(18,4);not null;default:0.0000"`
	SerSocio              bool       `gorm:"column:SerSocio;not null;default:0"`
	TarjetaSocioID        *string    `gorm:"column:TarjetaSocioID;size:40;uniqueIndex;default:null"`
	ClaseID               uint16     `gorm:"column:ClaseID;not null;default:1;index"`
	AgenteID              uint16     `gorm:"column:AgenteID;not null;default:0"`
	TransportistaID       uint16     `gorm:"column:TransportistaID;not null;default:0"`
	TransporteModoID      uint16     `gorm:"column:TransporteModoID;not null;default:0"`
	EnvioGasto            float64    `gorm:"column:EnvioGasto;type:decimal(14,4);not null;default:0.0000"`
	CocheNo               string     `gorm:"column:CocheNo;size:40;not null;default:''"`
	ChinoProhibido        bool       `gorm:"column:ChinoProhibido;not null;default:0"`
	Extrajero             bool       `gorm:"column:Extrajero;not null;default:0"`
	Idioma                int8       `gorm:"column:Idioma;not null;default:0"`
	IdiomaSerie           int8       `gorm:"column:IdiomaSerie;not null;default:0"`
	PrecioUsado           uint8      `gorm:"column:PrecioUsado;not null;default:0"`
	LoginEnabled          bool       `gorm:"column:LoginEnabled;not null;default:0"`
	ImprimirArticuloOrden uint16     `gorm:"column:ImprimirArticuloOrden;not null;default:0"`
	Bloqueado             bool       `gorm:"column:Bloqueado;not null;default:0"`
	Observacion           *string    `gorm:"column:Observacion;size:2048;default:null"`
}

// 表名指定（可选）
func (Proveedor) TableName() string {
	return "proveedor"
}
