package model

import "time"

// Articulo 结构体与数据库表字段一一对应
// decimal 用 float64，date 用 time.Time 或 *time.Time，tinyint 用 int8，bigint 用 int64，varchar 用 string
// 你可根据实际业务再做微调

type Articulo struct {
	ArticuloID               string     `json:"articuloid" gorm:"column:ArticuloID;primaryKey"`
	EmpresaID                int64      `json:"empresaid" gorm:"column:EmpresaID"`
	CodigoBarra              string     `json:"codigobarra" gorm:"column:CodigoBarra"`
	Prop1Titulo              string     `json:"prop1titulo" gorm:"column:Prop1Titulo"`
	Prop2Titulo              string     `json:"prop2titulo" gorm:"column:Prop2Titulo"`
	PropCount                int8       `json:"propcount" gorm:"column:PropCount"`
	NombreES                 string     `json:"nombrees" gorm:"column:NombreES"`
	NombreCN                 string     `json:"nombrecn" gorm:"column:NombreCN"`
	Descripcion              string     `json:"descripcion" gorm:"column:Descripcion"`
	PrecioDetalle            float64    `json:"preciodetalle" gorm:"column:PrecioDetalle"`
	PrecioDomicilio          float64    `json:"preciodomicilio" gorm:"column:PrecioDomicilio"`
	PrecioSocio              float64    `json:"preciosocio" gorm:"column:PrecioSocio"`
	PrecioMayor              float64    `json:"preciomayor" gorm:"column:PrecioMayor"`
	PrecioFactura            float64    `json:"preciofactura" gorm:"column:PrecioFactura"`
	PrecioInternet           float64    `json:"preciointernet" gorm:"column:PrecioInternet"`
	PrecioAmigo              float64    `json:"precioamigo" gorm:"column:PrecioAmigo"`
	PrecioEspecial           float64    `json:"precioespecial" gorm:"column:PrecioEspecial"`
	PrecioOferta             float64    `json:"preciooferta" gorm:"column:PrecioOferta"`
	PrecioCoste              float64    `json:"preciocoste" gorm:"column:PrecioCoste"`
	CantidadPorUnidad        float64    `json:"cantidadporunidad" gorm:"column:CantidadPorUnidad"`
	CantidadPorUnidad2       float64    `json:"cantidadporunidad2" gorm:"column:CantidadPorUnidad2"`
	VolumenPeso              float64    `json:"volumenpeso" gorm:"column:VolumenPeso"`
	UnidadUsarRegla          uint16     `json:"unidadusarregla" gorm:"column:UnidadUsarRegla"`
	ClaseID                  int        `json:"claseid" gorm:"column:ClaseID"`
	UnidadNombre             string     `json:"unidadnombre" gorm:"column:UnidadNombre"`
	FechaPrecioCoste         *time.Time `json:"fechapreciocoste" gorm:"column:FechaPrecioCoste"`
	Descuento                float64    `json:"descuento" gorm:"column:Descuento"`
	FacturaPorcentaje        float64    `json:"facturaporcentaje" gorm:"column:FacturaPorcentaje"`
	FechaCaducada            *time.Time `json:"fechacaducada" gorm:"column:FechaCaducada"`
	Oferta                   int8       `json:"oferta" gorm:"column:Oferta"`
	Privado                  int8       `json:"privado" gorm:"column:Privado"`
	UsarPrecioPorCantidad    int8       `json:"usarprecioporcantidad" gorm:"column:UsarPrecioPorCantidad"`
	UsarDescuentoPorCantidad int8       `json:"usardescuentoporcantidad" gorm:"column:UsarDescuentoPorCantidad"`
	Precio1                  float64    `json:"precio1" gorm:"column:Precio1"`
	Descuento1               float64    `json:"descuento1" gorm:"column:Descuento1"`
	Cantidad1                float64    `json:"cantidad1" gorm:"column:Cantidad1"`
	Precio2                  float64    `json:"precio2" gorm:"column:Precio2"`
	Descuento2               float64    `json:"descuento2" gorm:"column:Descuento2"`
	Cantidad2                float64    `json:"cantidad2" gorm:"column:Cantidad2"`
	Precio3                  float64    `json:"precio3" gorm:"column:Precio3"`
	Descuento3               float64    `json:"descuento3" gorm:"column:Descuento3"`
	Cantidad3                float64    `json:"cantidad3" gorm:"column:Cantidad3"`
	Precio4                  float64    `json:"precio4" gorm:"column:Precio4"`
	Descuento4               float64    `json:"descuento4" gorm:"column:Descuento4"`
	Cantidad4                float64    `json:"cantidad4" gorm:"column:Cantidad4"`
	Precio5                  float64    `json:"precio5" gorm:"column:Precio5"`
	Descuento5               float64    `json:"descuento5" gorm:"column:Descuento5"`
	Cantidad5                float64    `json:"cantidad5" gorm:"column:Cantidad5"`
	Precio6                  float64    `json:"precio6" gorm:"column:Precio6"`
	Descuento6               float64    `json:"descuento6" gorm:"column:Descuento6"`
	Nombre1                  string     `json:"nombre1" gorm:"column:Nombre1"`
	Nombre2                  string     `json:"nombre2" gorm:"column:Nombre2"`
	Nombre3                  string     `json:"nombre3" gorm:"column:Nombre3"`
	Nombre4                  string     `json:"nombre4" gorm:"column:Nombre4"`
	Nombre5                  string     `json:"nombre5" gorm:"column:Nombre5"`
	Nombre6                  string     `json:"nombre6" gorm:"column:Nombre6"`
	Nombre7                  string     `json:"nombre7" gorm:"column:Nombre7"`
	Nombre8                  string     `json:"nombre8" gorm:"column:Nombre8"`
	Nombre9                  string     `json:"nombre9" gorm:"column:Nombre9"`
	SitioEnAlmacen           string     `json:"sitioenalmacen" gorm:"column:SitioEnAlmacen"`
	SitioEnEstante           string     `json:"sitioenestante" gorm:"column:SitioEnEstante"`
	SerialNo                 string     `json:"serialno" gorm:"column:SerialNo"`
	MiniStock                float64    `json:"ministock" gorm:"column:MiniStock"`
	MaxiStock                float64    `json:"maxistock" gorm:"column:MaxiStock"`
	DibujoID                 int64      `json:"dibujoid" gorm:"column:DibujoID"`
	Recomendado              int8       `json:"recomendado" gorm:"column:Recomendado"`
	DescuentoCambioProhibido int8       `json:"descuentocambioprohibido" gorm:"column:DescuentoCambioProhibido"`
	AliIngrediente           string     `json:"aliingrediente" gorm:"column:AliIngrediente"`
	AliPesoTotal             string     `json:"alipesototal" gorm:"column:AliPesoTotal"`
	AliPesoNeto              string     `json:"alipesoneto" gorm:"column:AliPesoNeto"`
	AliFechaCaducada         string     `json:"alifechacaducada" gorm:"column:AliFechaCaducada"`
	AliLugarFabricante       string     `json:"alilugarfabricante" gorm:"column:AliLugarFabricante"`
	AliImportador            string     `json:"aliimportador" gorm:"column:AliImportador"`
	AliNumeroSanitario       string     `json:"alinumerosanitario" gorm:"column:AliNumeroSanitario"`
	AliNumeroLote            string     `json:"alinumerolote" gorm:"column:AliNumeroLote"`
	AliAdjuncion             string     `json:"aliadjuncion" gorm:"column:AliAdjuncion"`
	MultiCodigo              string     `json:"multicodigo" gorm:"column:MultiCodigo"`
	//FechaEntrada             *time.Time `json:"fechaentrada" gorm:"column:FechaEntrada"`
	OrdenNo      uint32 `json:"ordenno" gorm:"column:OrdenNo"`
	OrdenNoFinal int64  `json:"ordernofinal" gorm:"column:OrdenNoFinal"`
	Bloqueado    int8   `json:"bloqueado" gorm:"column:Bloqueado"`
	//SignoEspecial *string `json:"signoespecial" gorm:"column:SignoEspecial; -:create"`
	Observacion *string `json:"observacion" gorm:"column:Observacion"`
}

func (Articulo) TableName() string {
	return "articulo"
}

type ArticuloScanResult struct {
	Articulo
	Proveedordd string  `gorm:"column:proveedordd"`
	Proveedorid int     `gorm:"column:proveedorid"`
	Stockda     float64 `gorm:"column:stockda"`
	Dibujo      []byte  `gorm:"column:dibujo"`
}
type ArticuloScanRequest struct {
	ArticuloID  string `json:"articuloid"`
	CodigoBarra string `json:"codigobarra"`
}

type Response struct {
	Code    string   `json:"code"`
	Data    Articulo `json:"data"`
	Message string   `json:"message"`
}

type ArticuloScanResponse struct {
	ArticuloID               string  `json:"articuloid"`
	EmpresaID                string  `json:"empresaid"`
	StockDA                  string  `json:"stockda"`
	CodigoBarra              string  `json:"codigobarra"`
	Descripcion              string  `json:"descripcion"`
	PrecioDetalle            float64 `json:"preciodetalle"`
	PrecioDomicilio          float64 `json:"preciodomicilio"`
	PrecioSocio              float64 `json:"preciosocio"`
	PrecioMayor              float64 `json:"preciomayor"`
	PrecioFactura            float64 `json:"preciofactura"`
	PrecioInternet           float64 `json:"preciointernet"`
	PrecioAmigo              float64 `json:"precioamigo"`
	PrecioEspecial           float64 `json:"precioespecial"`
	PrecioOferta             float64 `json:"preciooferta"`
	PrecioCoste              float64 `json:"preciocoste"`
	NombreES                 string  `json:"nombrees"`
	PrimeraLetra             *string `json:"primeraletra"`
	NombreCN                 string  `json:"nombrecn"`
	Pinyin                   *string `json:"pinyin"`
	CantidadPorUnidad        float64 `json:"cantidadporunidad"`
	CantidadPorUnidad2       float64 `json:"cantidadporunidad2"`
	VolumenPeso              float64 `json:"volumenpeso"`
	ClaseID                  int     `json:"claseid"`
	UnidadNombre             string  `json:"unidadnombre"`
	FechaPrecioCoste         *string `json:"fechapreciocoste"`
	Descuento                float64 `json:"descuento"`
	ValeDescuento            *string `json:"valedescuento"`
	FacturaPorcentaje        float64 `json:"facturaporcentaje"`
	FechaCaducada            *string `json:"fechacaducada"`
	Oferta                   int     `json:"oferta"`
	ProveedorDD              string  `json:"proveedordd"`
	Privado                  int     `json:"privado"`
	UsarPrecioPorCantidad    int     `json:"usarprecioporcantidad"`
	UsarDescuentoPorCantidad int     `json:"usardescuentoporcantidad"`
	Precio1                  float64 `json:"precio1"`
	Descuento1               float64 `json:"descuento1"`
	Cantidad1                float64 `json:"cantidad1"`
	Precio2                  float64 `json:"precio2"`
	Descuento2               float64 `json:"descuento2"`
	Cantidad2                float64 `json:"cantidad2"`
	Precio3                  float64 `json:"precio3"`
	Descuento3               float64 `json:"descuento3"`
	Cantidad3                float64 `json:"cantidad3"`
	Precio4                  float64 `json:"precio4"`
	Descuento4               float64 `json:"descuento4"`
	Cantidad4                float64 `json:"cantidad4"`
	Precio5                  float64 `json:"precio5"`
	Descuento5               float64 `json:"descuento5"`
	Cantidad5                float64 `json:"cantidad5"`
	Precio6                  float64 `json:"precio6"`
	Descuento6               float64 `json:"descuento6"`
	SitioEnAlmacen           string  `json:"sitioenalmacen"`
	MiniStock                float64 `json:"ministock"`
	MaxiStock                float64 `json:"maxistock"`
	DibujoMD5                *string `json:"dibujomd5"`
	TiempoDibujoModificado   *string `json:"tiempodibujomodificado"`
	DescuentoCambioProhibido int     `json:"descuentocambioprohibido"`
	UnidadUsarRegla          int     `json:"unidadusarregla"`
	MultiCodigo              string  `json:"multicodigo"`
	ConsultaParcial          *string `json:"consultaparcial"`
	FechaEntrada             *string `json:"fechaentrada"`
	Bloqueado                int     `json:"bloqueado"`
	SignoEspecial            *string `json:"signoespecial"`
	Observacion              string  `json:"observacion"`
	Dibujo                   *string `json:"dibujo"`
	DibujoID                 int     `json:"dibujoid"`
}

type ArticuloInputRequest struct {
	ArticuloID    string `json:"articuloid"`
	CodigoBarra   string `json:"codigobarra"`
	NombreES      string `json:"nombrees"`
	NombreCN      string `json:"nombrecn"`
	PrecioCoste   string `json:"preciocoste"`
	PrecioDetalle string `json:"preciodetalle"`
	PrecioMayor   string `json:"preciomayor"`
	ClaseID       string `json:"claseid"`
	EmpresaID     string `json:"empresaid"`
	Observacion   string `json:"observacion"`
	StockDA       int    `json:"stockda"`
	Descuento     int    `json:"descuento"`
	Dibujo        string `json:"dibujo"`
	DibujoID      string `gorm:"column:DibujoID"`
	Proveedordd   string `gorm:"column:proveedordd"`
}

// ArticuloClass 商品分类模型
type ArticuloClass struct {
	ClaseID  string `json:"claseid"`
	NombreES string `json:"nombrees"`
}

type ProveedorResponse struct {
	EmpresaID string `json:"empresaID"`
	NombreES  string `json:"nombreES"`
}

type ClaseBriefResponse struct {
	ClaseID  string `json:"claseid"`
	NombreES string `json:"nombreES"`
}

// ArticuloExtra 商品额外信息模型
type ArticuloExtra struct {
	ArticuloID      string    `json:"articuloid" gorm:"column:ArticuloID;primaryKey"`
	UpdateTimeStamp time.Time `json:"updatetimestamp" gorm:"column:UpdateTimeStamp"`
}

func (ArticuloExtra) TableName() string {
	return "articuloextra"
}
