package model

type ZbmParam struct {
	CodePrefix string `json:"codePrefix"`
	CodeLength int    `json:"codeLength"`
}

// ImageUploadRequest 图片上传请求结构
type ImageUploadRequest struct {
	ArticuloID string `json:"articuloID" binding:"required"`
	Dibujo     string `json:"dibujo" binding:"required"`
}

// ImageUploadResponse 图片上传响应结构
type ImageUploadResponse struct {
	FilePath string `json:"filePath"`
	Success  bool   `json:"success"`
	Message  string `json:"message"`
}

type ArticuloService interface {
	Scan(request ArticuloScanRequest) *ArticuloScanResult
	Update(request ArticuloInputRequest) interface{}
	Edit(ac Articulo) interface{}
	Add(request ArticuloInputRequest) interface{}
	GetAcClass() []ArticuloClase
	GetProveedor() []Proveedor
	UpdateByArticuloIDOrCodigoBarra(articulo Articulo) int
	GetByArticuloIDOrCodigoBarra(articuloID string) []Articulo
	GetByArticuloIDOrCodigoBarraLike(articuloID string) []Articulo
	GetByArticuloIDOrCodigoBarraActually(articuloID string) []Articulo
	GetByArticuloID(articuloID string) *Articulo
	GetByProductName(productName string) []Articulo
	Zbm(param ZbmParam) interface{}
	UpdateDibujoID(articuloID string, dibujoID int64) error
	UploadImage(articuloID, dibujo string) error
}
