package model

type ArticuloClase struct {
	ClaseID                           uint16  `gorm:"column:ClaseID;primaryKey"` // smallint unsigned
	PadreID                           uint16  `gorm:"column:PadreID"`
	NombreES                          string  `gorm:"column:NombreES"`
	NombreCN                          string  `gorm:"column:NombreCN"`
	IVAID                             uint16  `gorm:"column:IVAID"`
	Descuento                         float64 `gorm:"column:Descuento"`
	Descuento1                        float64 `gorm:"column:Descuento1"`
	Descuento2                        float64 `gorm:"column:Descuento2"`
	Descuento3                        float64 `gorm:"column:Descuento3"`
	Descuento4                        float64 `gorm:"column:Descuento4"`
	Descuento5                        float64 `gorm:"column:Descuento5"`
	Descuento6                        float64 `gorm:"column:Descuento6"`
	Descuento7                        float64 `gorm:"column:Descuento7"`
	Descuento8                        float64 `gorm:"column:Descuento8"`
	Descuento9                        float64 `gorm:"column:Descuento9"`
	TicketDescuentoUsarRegla          uint8   `gorm:"column:TicketDescuentoUsarRegla"`
	FacturaPorcentaje                 float64 `gorm:"column:FacturaPorcentaje"`
	UnidadUsarRegla                   uint16  `gorm:"column:UnidadUsarRegla"`
	UnidadNombre                      string  `gorm:"column:UnidadNombre"`
	ContarGanancias                   int     `gorm:"column:ContarGanancias"`
	ContarVolumenPeso                 int     `gorm:"column:ContarVolumenPeso"`
	StockBloqueado                    int     `gorm:"column:StockBloqueado"`
	PadreGrupo                        string  `gorm:"column:PadreGrupo"`
	NecesitaSerialNo                  int     `gorm:"column:NecesitaSerialNo"`
	DescuentoCambioProhibido          int     `gorm:"column:DescuentoCambioProhibido"`
	ClienteInvisible                  int     `gorm:"column:ClienteInvisible"`
	Oferta                            int     `gorm:"column:Oferta"`
	Privado                           int     `gorm:"column:Privado"`
	ArticuloTipo                      uint16  `gorm:"column:ArticuloTipo"`
	Nombre1                           string  `gorm:"column:Nombre1"`
	Nombre2                           string  `gorm:"column:Nombre2"`
	Nombre3                           string  `gorm:"column:Nombre3"`
	Nombre4                           string  `gorm:"column:Nombre4"`
	Nombre5                           string  `gorm:"column:Nombre5"`
	Nombre6                           string  `gorm:"column:Nombre6"`
	Nombre7                           string  `gorm:"column:Nombre7"`
	Nombre8                           string  `gorm:"column:Nombre8"`
	Nombre9                           string  `gorm:"column:Nombre9"`
	PrecioDetalleGananciaPorcentaje   float64 `gorm:"column:PrecioDetalleGananciaPorcentaje"`
	PrecioDomicilioGananciaPorcentaje float64 `gorm:"column:PrecioDomicilioGananciaPorcentaje"`
	PrecioSocioGananciaPorcentaje     float64 `gorm:"column:PrecioSocioGananciaPorcentaje"`
	PrecioMayorGananciaPorcentaje     float64 `gorm:"column:PrecioMayorGananciaPorcentaje"`
	PrecioFacturaGananciaPorcentaje   float64 `gorm:"column:PrecioFacturaGananciaPorcentaje"`
	PrecioInternetGananciaPorcentaje  float64 `gorm:"column:PrecioInternetGananciaPorcentaje"`
	PrecioAmigoGananciaPorcentaje     float64 `gorm:"column:PrecioAmigoGananciaPorcentaje"`
	PrecioEspecialGananciaPorcentaje  float64 `gorm:"column:PrecioEspecialGananciaPorcentaje"`
	PrecioOfertaGananciaPorcentaje    float64 `gorm:"column:PrecioOfertaGananciaPorcentaje"`
	Bloqueado                         int     `gorm:"column:Bloqueado"`
	Observacion                       *string `gorm:"column:Observacion"` // nullable 字段
}

// 表名绑定（可选）
func (ArticuloClase) TableName() string {
	return "articuloclase"
}

// ArticuloClaseService 商品分类服务接口
type ArticuloClaseService interface {
	GetCategoryById(catId int) *ArticuloClase
}
