package service

import (
	"gorm.io/gorm"
	"log"
	"supermarket-go/internal/model"
)

type ArticuloClaseServiceImpl struct {
	db *gorm.DB
}

func NewArticuloClaseService(db *gorm.DB) model.ArticuloClaseService {
	return &ArticuloClaseServiceImpl{db: db}
}

// GetCategoryById 根据分类ID获取商品分类信息
func (s *ArticuloClaseServiceImpl) GetCategoryById(catId int) *model.ArticuloClase {
	log.Printf("[INFO] 开始获取商品分类信息: ClaseID=%d", catId)

	var articuloClase model.ArticuloClase
	if err := s.db.Where("ClaseID = ?", catId).First(&articuloClase).Error; err != nil {
		log.Printf("[ERROR] 获取商品分类信息失败: %v", err)
		return nil
	}

	log.Printf("[INFO] 成功获取商品分类信息: ClaseID=%d, NombreES=%s, IVAID=%d", 
		articuloClase.ClaseID, articuloClase.NombreES, articuloClase.IVAID)
	return &articuloClase
} 