package service

import (
	"io"
	"supermarket-go/internal/model"
)

// ArticulodibujoService 商品图片服务接口
type ArticulodibujoService interface {
	// SaveOrUpdateArticuloDibujo 保存或更新商品图片
	SaveOrUpdateArticuloDibujo(articuloID string, inputStream io.Reader) (bool, error)

	// GetByMD5 根据MD5获取商品图片
	GetByMD5(md5 string) (*model.ArticuloDibujo, error)

	// GetByIdExactly 根据商品ID获取商品图片
	GetByIdExactly(id string) (*model.ArticuloDibujo, error)
}
