package service

import (
	"gorm.io/gorm"
	"log"
	"time"
)

type ProcedureServiceImpl struct {
	db *gorm.DB
}

// GenerateDocumentoNo 生成文档号
func (s *ProcedureServiceImpl) GenerateDocumentoNo(tableName string, dateStr string) int64 {
	log.Printf("[INFO] 开始生成文档号: tableName=%s, dateStr=%s", tableName, dateStr)

	// 调用存储过程 new_document_no
	var documentNo int64
	err := s.db.Raw("CALL new_document_no(?, ?, ?)", tableName, dateStr, &documentNo).Scan(&documentNo).Error
	if err != nil {
		log.Printf("[ERROR] 调用存储过程 new_document_no 失败: %v", err)
		// 如果存储过程调用失败，使用时间戳作为备选方案
		documentNo = time.Now().UnixNano() / 1000000
		log.Printf("[WARN] 使用时间戳作为备选文档号: %d", documentNo)
		return documentNo
	}

	log.Printf("[INFO] 成功生成文档号: %d", documentNo)
	return documentNo
}

// GenerateTicketNo 生成订单号
func (s *ProcedureServiceImpl) GenerateTicketNo(dateStr string) int64 {
	log.Printf("[INFO] 开始生成订单号: dateStr=%s", dateStr)

	// 调用存储过程 new_ticket_no
	var ticketNo int64
	err := s.db.Raw("SELECT new_ticket_no(?)", dateStr).Scan(&ticketNo).Error
	if err != nil {
		log.Printf("[ERROR] 调用存储过程 new_ticket_no 失败: %v", err)
		// 如果存储过程调用失败，使用时间戳作为备选方案
		ticketNo = time.Now().UnixNano() / 1000000
		log.Printf("[WARN] 使用时间戳作为备选订单号: %d", ticketNo)
		return ticketNo
	}

	log.Printf("[INFO] 成功生成订单号: %d", ticketNo)
	return ticketNo
}
