package util

import (
	"log"
	"os"
	"time"
)

// InitLogger 初始化日志配置
func InitLogger() {
	// 设置日志格式
	log.SetFlags(log.Ldate | log.Ltime | log.Lmicroseconds | log.Lshortfile)

	// 创建日志文件
	_, err := os.OpenFile("supermarket.log", os.O_CREATE|os.O_WRONLY|os.O_APPEND, 0666)
	if err != nil {
		log.Printf("[ERROR] 无法创建日志文件: %v", err)
		return
	}

	// 同时输出到文件和控制台
	log.SetOutput(os.Stdout)

	log.Printf("[INFO] 日志系统初始化完成，日志文件: supermarket.log")
}

// LogRequest 记录HTTP请求日志
func LogRequest(method, path, clientIP string, statusCode int, duration time.Duration) {
	log.Printf("[HTTP] %s %s %s %d %v", method, path, clientIP, statusCode, duration)
}

// LogSQL 记录SQL执行日志
func LogSQL(sql string, args ...interface{}) {
	log.Printf("[SQL] %s | Args: %v", sql, args)
}

// LogError 记录错误日志
func LogError(message string, err error) {
	if err != nil {
		log.Printf("[ERROR] %s: %v", message, err)
	} else {
		log.Printf("[ERROR] %s", message)
	}
}

// LogInfo 记录信息日志
func LogInfo(message string, args ...interface{}) {
	if len(args) > 0 {
		log.Printf("[INFO] "+message, args...)
	} else {
		log.Printf("[INFO] %s", message)
	}
}

// LogWarn 记录警告日志
func LogWarn(message string, args ...interface{}) {
	if len(args) > 0 {
		log.Printf("[WARN] "+message, args...)
	} else {
		log.Printf("[WARN] %s", message)
	}
}

// LogDebug 记录调试日志
func LogDebug(message string, args ...interface{}) {
	if len(args) > 0 {
		log.Printf("[DEBUG] "+message, args...)
	} else {
		log.Printf("[DEBUG] %s", message)
	}
}
