#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
图片上传接口测试脚本
"""

import requests
import base64
import json

def test_image_upload():
    """测试图片上传接口"""
    
    # 服务器地址
    base_url = "http://localhost:8080"
    upload_url = f"{base_url}/image/upload"
    
    # 创建一个简单的测试图片（1x1像素的红色PNG）
    # 这是一个最小的PNG图片的base64编码
    test_image_base64 = "iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mNkYPhfDwAChwGA60e6kgAAAABJRU5ErkJggg=="
    
    # 请求数据
    data = {
        "articuloID": "TEST001",
        "dibujo": test_image_base64
    }
    
    # 发送POST请求
    try:
        print("正在发送图片上传请求...")
        print(f"URL: {upload_url}")
        print(f"ArticuloID: {data['articuloID']}")
        print(f"图片数据长度: {len(data['dibujo'])} 字符")
        
        response = requests.post(
            upload_url,
            json=data,
            headers={'Content-Type': 'application/json'},
            timeout=30
        )
        
        print(f"\n响应状态码: {response.status_code}")
        print(f"响应头: {dict(response.headers)}")
        
        if response.status_code == 200:
            result = response.json()
            print(f"响应内容: {json.dumps(result, indent=2, ensure_ascii=False)}")
            
            if result.get('code') == '200':
                print("✅ 图片上传成功！")
                file_path = result.get('data', {}).get('filePath')
                if file_path:
                    print(f"📁 图片保存路径: {file_path}")
            else:
                print(f"❌ 上传失败: {result.get('message', '未知错误')}")
        else:
            print(f"❌ 请求失败: {response.status_code}")
            print(f"错误内容: {response.text}")
            
    except requests.exceptions.ConnectionError:
        print("❌ 连接失败: 请确保服务器正在运行在 localhost:8080")
    except requests.exceptions.Timeout:
        print("❌ 请求超时")
    except Exception as e:
        print(f"❌ 发生错误: {e}")

if __name__ == "__main__":
    print("=== 图片上传接口测试 ===")
    test_image_upload()
