package controller

import (
	"log"
	"net/http"
	"supermarket-go/internal/service"
	"github.com/gin-gonic/gin"
)

type ClientController struct {
	ClienteService *service.ClienteService
}

func RegisterClientRoutes(r *gin.Engine, cliSvc *service.ClienteService) {
	log.Println("[INFO] 注册 client 路由组: /client")
	ctrl := &ClientController{ClienteService: cliSvc}
	g := r.Group("/client")
	{
		g.GET("/listAllClients", ctrl.ListAllClients)
	}
	log.Println("[INFO] client 路由注册完成")
}

func (ctrl *ClientController) ListAllClients(c *gin.Context) {
	log.Println("[INFO] ===== 开始处理获取所有客户列表请求 =====")
	
	clients := ctrl.ClienteService.ListAllClients()
	log.Printf("[INFO] 查询到 %d 个客户", len(clients))
	
	log.Println("[INFO] ===== 获取所有客户列表请求处理完成 =====")
	c.JSON(http.StatusOK, gin.H{"code": 200, "message": "success", "data": clients})
}