package model

import "time"

type Cliente struct {
	EmpresaID             uint64     `gorm:"column:EmpresaID;primaryKey"`
	NombreES              string     `gorm:"column:NombreES"`
	NombreCN              string     `gorm:"column:NombreCN"`
	CIF                   string     `gorm:"column:CIF"`
	NumeroIVA             string     `gorm:"column:NumeroIVA"`
	Domicilio             string     `gorm:"column:Domicilio"`
	CodigoPostal          string     `gorm:"column:CodigoPostal"`
	Poblacion             string     `gorm:"column:Poblacion"`
	Provincia             string     `gorm:"column:Provincia"`
	Pais                  string     `gorm:"column:Pais"`
	CountryID             string     `gorm:"column:CountryID"`
	PersonaContacto       string     `gorm:"column:PersonaContacto"`
	Sexo                  uint16     `gorm:"column:Sexo"`
	Cumpleano             *time.Time `gorm:"column:Cumpleano"`
	Telefono              string     `gorm:"column:Telefono"`
	Telefono2             string     `gorm:"column:Telefono2"`
	Fax                   string     `gorm:"column:Fax"`
	Email                 string     `gorm:"column:Email"`
	Web                   string     `gorm:"column:Web"`
	IM                    string     `gorm:"column:IM"`
	IVAClase              uint8      `gorm:"column:IVAClase"`
	ReglaIVA              uint8      `gorm:"column:ReglaIVA"`
	FacturaPorcentaje     float64    `gorm:"column:FacturaPorcentaje"`
	FacturaDescuento      float64    `gorm:"column:FacturaDescuento"`
	FacturaSDIID          string     `gorm:"column:FacturaSDIID"`
	FacturaCEC            string     `gorm:"column:FacturaCEC"`
	BancoCuentaNo         string     `gorm:"column:BancoCuentaNo"`
	NecesitaFactura       bool       `gorm:"column:NecesitaFactura"`
	AutoEmailDocumento    bool       `gorm:"column:AutoEmailDocumento"`
	Descuento             float64    `gorm:"column:Descuento"`
	DescuentoSerie        int        `gorm:"column:DescuentoSerie"`
	DescuentoExtra        float64    `gorm:"column:DescuentoExtra"`
	MaxSobregiro          float64    `gorm:"column:MaxSobregiro"`
	SerSocio              bool       `gorm:"column:SerSocio"`
	TarjetaSocioID        *string    `gorm:"column:TarjetaSocioID"`
	ClaseID               uint16     `gorm:"column:ClaseID"`
	AgenteID              uint16     `gorm:"column:AgenteID"`
	TransportistaID       uint16     `gorm:"column:TransportistaID"`
	TransporteModoID      uint16     `gorm:"column:TransporteModoID"`
	EnvioGasto            float64    `gorm:"column:EnvioGasto"`
	CocheNo               string     `gorm:"column:CocheNo"`
	ChinoProhibido        bool       `gorm:"column:ChinoProhibido"`
	Extrajero             bool       `gorm:"column:Extrajero"`
	Idioma                int        `gorm:"column:Idioma"`
	IdiomaSerie           int        `gorm:"column:IdiomaSerie"`
	PrecioUsado           uint8      `gorm:"column:PrecioUsado"`
	LoginEnabled          bool       `gorm:"column:LoginEnabled"`
	ImprimirArticuloOrden uint16     `gorm:"column:ImprimirArticuloOrden"`
	Bloqueado             bool       `gorm:"column:Bloqueado"`
	Observacion           *string    `gorm:"column:Observacion"`
}

// TableName 指定表名
func (Cliente) TableName() string {
	return "cliente"
}
