package model

type ReturnOrder struct {
	DocumentoNo int64  `gorm:"column:documento_no;primaryKey" json:"documentoNo"`
	Code        string `gorm:"column:code" json:"code"`
	Bloqueado   string `gorm:"column:bloqueado" json:"bloqueado"`
	// ... 其它字段 ...
}

type ReturnArticulo struct {
	ID          int64   `gorm:"column:id;primaryKey" json:"id"`
	DocumentoNo int64   `gorm:"column:documento_no" json:"documentoNo"`
	Code        string  `gorm:"column:code" json:"code"`
	Name        string  `gorm:"column:name" json:"name"`
	Amount      int     `gorm:"column:amount" json:"amount"`
	Precio      float64 `gorm:"column:precio" json:"precio"`
	// ... 其它字段 ...
}

// ReturnGoodsListDTO 对应Java的ReturnGoodsListDTO
type ReturnGoodsListDTO struct {
	EmpresaId    string                    `json:"empresaId"`
	ArticuloList []ReturnGoodsListArticulo `json:"articuloList"`
}

// ReturnGoodsListArticulo 对应Java的ReturnGoodsListDTO.Articulo
type ReturnGoodsListArticulo struct {
	Type     int     `json:"type"`   // 商品识别类型 0: ArticuloId 1: CodigoBarra
	Value    string  `json:"value"`  // 键值
	Amount   int     `json:"amount"` // 要退货的数量 (正数)
	Precio   float64 `json:"precio"`
	Nombre   string  `json:"nombre"`
	NombreCN string  `json:"nombreCN"`
	NombreES string  `json:"nombreES"`
	ClassID  int     `json:"classId"`
}
