package model

import "time"

// TicketDiarioTotal 日总额统计
type TicketDiarioTotal struct {
	Fecha                time.Time `gorm:"column:Fecha;primaryKey;type:date"`
	Total                float64   `gorm:"column:Total;type:decimal(14,4);not null;default:0.0000"`
	CantidadTotal        float64   `gorm:"column:CantidadTotal;type:decimal(14,4);not null;default:0.0000"`
	PaqueteTotal         float64   `gorm:"column:PaqueteTotal;type:decimal(14,4);not null;default:0.0000"`
	CajaTotal            float64   `gorm:"column:CajaTotal;type:decimal(14,4);not null;default:0.0000"`
	VolumenPesoTotal     float64   `gorm:"column:VolumenPesoTotal;type:decimal(14,4);not null;default:0.0000"`
	LineaTotal           int       `gorm:"column:LineaTotal;not null;default:0"`
	Efectivo             float64   `gorm:"column:Efectivo;type:decimal(14,4);not null;default:0.0000"`
	Tarjeta              float64   `gorm:"column:Tarjeta;type:decimal(14,4);not null;default:0.0000"`
	Cheque               float64   `gorm:"column:Cheque;type:decimal(14,4);not null;default:0.0000"`
	Transferencia        float64   `gorm:"column:Transferencia;type:decimal(14,4);not null;default:0.0000"`
	Vale                 float64   `gorm:"column:Vale;type:decimal(14,4);not null;default:0.0000"`
	Descuento            float64   `gorm:"column:Descuento;type:decimal(14,4);not null;default:0.0000"`
	ValeSalida           float64   `gorm:"column:ValeSalida;type:decimal(14,4);not null;default:0.0000"`
	DescuentoCliente     float64   `gorm:"column:DescuentoCliente;type:decimal(14,4);not null;default:0.0000"`
	Otro                 float64   `gorm:"column:Otro;type:decimal(14,4);not null;default:0.0000"`
	Pendiente            float64   `gorm:"column:Pendiente;type:decimal(14,4);not null;default:0.0000"`
	GenTiendasCadenaDatos int      `gorm:"column:GenTiendasCadenaDatos;type:tinyint;not null;default:0"`
}

// TableName 指定表名
func (TicketDiarioTotal) TableName() string {
	return "ticketdiariototal"
}

// TicketDiarioTotalService 日总额统计服务接口
type TicketDiarioTotalService interface {
	RecordTicket(paid []float64) bool
} 