package service

import (
	"gorm.io/gorm"
	"supermarket-go/internal/model"
)

type AlbaranproveedorService struct {
	db *gorm.DB
}

func NewAlbaranproveedorService(db *gorm.DB) *AlbaranproveedorService {
	return &AlbaranproveedorService{db: db}
}

func (s *AlbaranproveedorService) DyDzOrder(code, bloqueado string) []model.Documento {
	var orders []model.AlbaranProveedorDto
	query := `SELECT alp.*, prov.NombreES as ProNombreES FROM albaranproveedor AS alp , proveedor AS prov
        WHERE 1 = 1 AND alp.EmpresaID = prov.EmpresaID`
	var params []interface{}

	// 如果code不为空，添加查询条件
	if code != "" {
		query += ` AND (alp.DocumentoNo LIKE ? OR prov.NombreES LIKE ? OR prov.NombreCN LIKE ?)`
		params = append(params, "%"+code+"%", "%"+code+"%", "%"+code+"%")
	}
	if bloqueado != "" {
		query += ` AND (alp.Bloqueado =?)`
		params = append(params, bloqueado)
	}
	query += ` ORDER BY alp.DocumentoNo DESC`

	if err := s.db.Raw(query, params...).Scan(&orders).Error; err != nil {
		return nil
	}

	// 过滤总金额大于0的记录并转换为Documento类型
	var filteredOrders []model.Documento
	for _, order := range orders {
		if order.Total > 0 {
			documento := order.ConvertToDocumento()
			filteredOrders = append(filteredOrders, documento)
		}
	}

	return filteredOrders
}

func (s *AlbaranproveedorService) QueryByAlbaranProveedorNo(code string) *model.AlbaranProveedor {
	var order model.AlbaranProveedor
	query := `
		SELECT alp.*, prov.NombreES as ProNombreES 
		FROM albaranproveedor alp 
		JOIN proveedor prov ON alp.EmpresaID = prov.EmpresaID 
		WHERE alp.DocumentoNo = ?
	`
	if err := s.db.Raw(query, code).Scan(&order).Error; err != nil {
		return nil
	}
	return &order
}
