package service

import (
	"supermarket-go/internal/model"
)

// ArticuloTableImportService 商品表格导入服务接口
type ArticuloTableImportService interface {
	// Resolve 解析URL，返回解析结果
	Resolve(url string) (*model.ResolveResult, error)

	// Import 导入商品数据
	// empresaID: 供货商 ID
	// empleadoID: 职员 ID
	// importType: 0 按 id匹配, 1 按 条码匹配, 2 id和条码都匹配
	// data: 商品数据列表
	// updateSalePrice: 是否更新已有商品的销售价
	// updateOnly: 仅更新销售价
	// 返回: 是否上传成功
	Import(empresaID int64, empleadoID int, importType int, data []model.TableRow, updateSalePrice bool, updateOnly bool, isSaveImage bool) (bool, error)
}
