package model

import "time"

type Proveedor struct {
	EmpresaID             uint64     `gorm:"primaryKey;column:EmpresaID"`
	NombreES              string     `gorm:"size:60;not null;default:''"`
	NombreCN              string     `gorm:"size:60;not null;default:''"`
	CIF                   string     `gorm:"size:60;not null;default:''"`
	NumeroIVA             string     `gorm:"size:30;not null;default:''"`
	Domicilio             string     `gorm:"size:120;not null;default:''"`
	CodigoPostal          string     `gorm:"size:20;not null;default:''"`
	Poblacion             string     `gorm:"size:60;not null;default:''"`
	Provincia             string     `gorm:"size:60;not null;default:''"`
	Pais                  string     `gorm:"size:60;not null;default:''"`
	CountryID             string     `gorm:"size:2;not null;default:''"`
	PersonaContacto       string     `gorm:"size:60;not null;default:''"`
	Sexo                  uint16     `gorm:"not null;default:0"`
	Cumpleano             *time.Time `gorm:"column:Cumpleano"`
	Telefono              string     `gorm:"size:40;not null;default:''"`
	Telefono2             string     `gorm:"size:40;not null;default:''"`
	Fax                   string     `gorm:"size:40;not null;default:''"`
	Email                 string     `gorm:"size:60;not null;default:''"`
	Web                   string     `gorm:"size:60;not null;default:''"`
	IM                    string     `gorm:"size:40;not null;default:''"`
	IVAClase              uint8      `gorm:"not null;default:0"`
	ReglaIVA              uint8      `gorm:"not null;default:0"`
	FacturaPorcentaje     float64    `gorm:"type:decimal(5,2);not null;default:0.00"`
	FacturaDescuento      float64    `gorm:"type:decimal(5,2);not null;default:0.00"`
	FacturaSDIID          string     `gorm:"size:40;not null;default:''"`
	FacturaCEC            string     `gorm:"size:60;not null;default:''"`
	BancoCuentaNo         string     `gorm:"size:200;not null;default:''"`
	NecesitaFactura       bool       `gorm:"not null;default:0"`
	AutoEmailDocumento    bool       `gorm:"not null;default:0"`
	Descuento             float64    `gorm:"type:decimal(5,2);not null;default:0.00"`
	DescuentoSerie        int8       `gorm:"not null;default:0"`
	DescuentoExtra        float64    `gorm:"type:decimal(5,2);not null;default:0.00"`
	MaxSobregiro          float64    `gorm:"type:decimal(18,4);not null;default:0.0000"`
	SerSocio              bool       `gorm:"not null;default:0"`
	TarjetaSocioID        *string    `gorm:"size:40;uniqueIndex;default:null"`
	ClaseID               uint16     `gorm:"not null;default:1;index"`
	AgenteID              uint16     `gorm:"not null;default:0"`
	TransportistaID       uint16     `gorm:"not null;default:0"`
	TransporteModoID      uint16     `gorm:"not null;default:0"`
	EnvioGasto            float64    `gorm:"type:decimal(14,4);not null;default:0.0000"`
	CocheNo               string     `gorm:"size:40;not null;default:''"`
	ChinoProhibido        bool       `gorm:"not null;default:0"`
	Extrajero             bool       `gorm:"not null;default:0"`
	Idioma                int8       `gorm:"not null;default:0"`
	IdiomaSerie           int8       `gorm:"not null;default:0"`
	PrecioUsado           uint8      `gorm:"not null;default:0"`
	LoginEnabled          bool       `gorm:"not null;default:0"`
	ImprimirArticuloOrden uint16     `gorm:"not null;default:0"`
	Bloqueado             bool       `gorm:"not null;default:0"`
	Observacion           *string    `gorm:"size:2048;default:null"`
}

// 表名指定（可选）
func (Proveedor) TableName() string {
	return "proveedor"
}
