package model

type AlbaranProveedorArticulo struct {
	DocumentoNo              int64   `gorm:"column:DocumentoNo;primaryKey" json:"documentoNo"`
	ArticuloID               string  `gorm:"column:ArticuloID" json:"articuloID"`
	PropCount                int     `gorm:"column:PropCount" json:"propCount"`
	PropID1                  string  `gorm:"column:PropID1" json:"propID1"`
	PropID2                  string  `gorm:"column:PropID2" json:"propID2"`
	Propiedad                string  `gorm:"column:Propiedad" json:"propiedad"`
	SerialNo                 string  `gorm:"column:SerialNo" json:"serialNo"`
	CodigoBarra              string  `gorm:"column:CodigoBarra" json:"codigoBarra"`
	CodigoBarraBalanza       int     `gorm:"column:CodigoBarraBalanza" json:"codigoBarraBalanza"`
	NombreES                 string  `gorm:"column:NombreES" json:"nombreES"`
	NombreCN                 string  `gorm:"column:NombreCN" json:"nombreCN"`
	Precio                   float64 `gorm:"column:Precio" json:"precio"`
	Cantidad                 float64 `gorm:"column:Cantidad" json:"cantidad"`
	IVA                      float64 `gorm:"column:IVA" json:"iva"`
	REQ                      float64 `gorm:"column:REQ" json:"req"`
	Descuento                float64 `gorm:"column:Descuento" json:"descuento"`
	DescuentoCambioProhibido int     `gorm:"column:DescuentoCambioProhibido" json:"descuentoCambioProhibido"`
	PrecioCoste              float64 `gorm:"column:PrecioCoste" json:"precioCoste"`
	Comentario               string  `gorm:"column:Comentario" json:"comentario"`
	NecesitaSerialNo         int     `gorm:"column:NecesitaSerialNo" json:"necesitaSerialNo"`
	Temporal                 int     `gorm:"column:Temporal" json:"temporal"`
	OrdenNo                  int     `gorm:"column:OrdenNo" json:"ordenNo"`
	Articulo                 *Articulo `gorm:"-" json:"articulo"`
}

// DyDzOrderInfo2Response 用于dy_dz_order_info2接口的响应结构
type DyDzOrderInfo2Response struct {
	DocumentoNo              int64   `json:"documentoNo"`
	ArticuloID               string  `json:"articuloID"`
	PropCount                int     `json:"propCount"`
	PropID1                  string  `json:"propID1"`
	PropID2                  string  `json:"propID2"`
	Propiedad                string  `json:"propiedad"`
	SerialNo                 string  `json:"serialNo"`
	CodigoBarra              string  `json:"codigoBarra"`
	CodigoBarraBalanza       int     `json:"codigoBarraBalanza"`
	NombreES                 string  `json:"nombreES"`
	NombreCN                 string  `json:"nombreCN"`
	Precio                   float64 `json:"precio"`
	Cantidad                 float64 `json:"cantidad"`
	Descuento                float64 `json:"descuento"`
	DescuentoCambioProhibido int     `json:"descuentoCambioProhibido"`
	PrecioCoste              float64 `json:"precioCoste"`
	Comentario               string  `json:"comentario"`
	NecesitaSerialNo         int     `json:"necesitaSerialNo"`
	Temporal                 int     `json:"temporal"`
	OrdenNo                  int     `json:"ordenNo"`
	Articulo                 *ArticuloResponse `json:"articulo"`
	IVA                      float64 `json:"iva"`
	REQ                      float64 `json:"req"`
}

// DyDzOrderInfoResponse 用于dy_dz_order_info接口的响应结构
type DyDzOrderInfoResponse struct {
	DocumentoNo              int64   `json:"documentoNo"`
	ArticuloID               string  `json:"articuloID"`
	PropCount                int     `json:"propCount"`
	PropID1                  string  `json:"propID1"`
	PropID2                  string  `json:"propID2"`
	Propiedad                string  `json:"propiedad"`
	SerialNo                 string  `json:"serialNo"`
	CodigoBarra              string  `json:"codigoBarra"`
	CodigoBarraBalanza       int     `json:"codigoBarraBalanza"`
	NombreES                 string  `json:"nombreES"`
	NombreCN                 string  `json:"nombreCN"`
	Precio                   float64 `json:"precio"`
	Cantidad                 float64 `json:"cantidad"`
	Descuento                float64 `json:"descuento"`
	DescuentoCambioProhibido int     `json:"descuentoCambioProhibido"`
	PrecioCoste              float64 `json:"precioCoste"`
	Comentario               string  `json:"comentario"`
	NecesitaSerialNo         int     `json:"necesitaSerialNo"`
	Temporal                 int     `json:"temporal"`
	OrdenNo                  int     `json:"ordenNo"`
	Articulo                 *ArticuloResponse `json:"articulo"`
	IVA                      float64 `json:"iva"`
	REQ                      float64 `json:"req"`
}

// ArticuloResponse 用于dy_dz_order_info2接口的articulo响应结构
type ArticuloResponse struct {
	ArticuloID               string  `json:"articuloid"`
	EmpresaID                string  `json:"empresaid"`
	StockDA                  *string `json:"stockda"`
	CodigoBarra              string  `json:"codigobarra"`
	Descripcion              string  `json:"descripcion"`
	PrecioDetalle            float64 `json:"preciodetalle"`
	PrecioDomicilio          float64 `json:"preciodomicilio"`
	PrecioSocio              float64 `json:"preciosocio"`
	PrecioMayor              float64 `json:"preciomayor"`
	PrecioFactura            float64 `json:"preciofactura"`
	PrecioInternet           float64 `json:"preciointernet"`
	PrecioAmigo              float64 `json:"precioamigo"`
	PrecioEspecial           float64 `json:"precioespecial"`
	PrecioOferta             float64 `json:"preciooferta"`
	PrecioCoste              float64 `json:"preciocoste"`
	NombreES                 string  `json:"nombrees"`
	PrimeraLetra             *string `json:"primeraletra"`
	NombreCN                 string  `json:"nombrecn"`
	Pinyin                   *string `json:"pinyin"`
	CantidadPorUnidad        float64 `json:"cantidadporunidad"`
	CantidadPorUnidad2       float64 `json:"cantidadporunidad2"`
	VolumenPeso              float64 `json:"volumenpeso"`
	ClaseID                  int     `json:"claseid"`
	UnidadNombre             string  `json:"unidadnombre"`
	FechaPrecioCoste         *int64  `json:"fechapreciocoste"`
	Descuento                float64 `json:"descuento"`
	ValeDescuento            *string `json:"valedescuento"`
	FacturaPorcentaje        float64 `json:"facturaporcentaje"`
	FechaCaducada            *string `json:"fechacaducada"`
	Oferta                   int     `json:"oferta"`
	ProveedorDD              *string `json:"proveedordd"`
	Privado                  int     `json:"privado"`
	UsarPrecioPorCantidad    int     `json:"usarprecioporcantidad"`
	UsarDescuentoPorCantidad int     `json:"usardescuentoporcantidad"`
	Precio1                  float64 `json:"precio1"`
	Descuento1               float64 `json:"descuento1"`
	Cantidad1                float64 `json:"cantidad1"`
	Precio2                  float64 `json:"precio2"`
	Descuento2               float64 `json:"descuento2"`
	Cantidad2                float64 `json:"cantidad2"`
	Precio3                  float64 `json:"precio3"`
	Descuento3               float64 `json:"descuento3"`
	Cantidad3                float64 `json:"cantidad3"`
	Precio4                  float64 `json:"precio4"`
	Descuento4               float64 `json:"descuento4"`
	Cantidad4                float64 `json:"cantidad4"`
	Precio5                  float64 `json:"precio5"`
	Descuento5               float64 `json:"descuento5"`
	Cantidad5                float64 `json:"cantidad5"`
	Precio6                  float64 `json:"precio6"`
	Descuento6               float64 `json:"descuento6"`
	SitioEnAlmacen           string  `json:"sitioenalmacen"`
	MiniStock                float64 `json:"ministock"`
	MaxiStock                float64 `json:"maxistock"`
	DibujoMD5                *string `json:"dibujomd5"`
	TiempoDibujoModificado   *string `json:"tiempodibujomodificado"`
	DescuentoCambioProhibido int     `json:"descuentocambioprohibido"`
	UnidadUsarRegla          int     `json:"unidadusarregla"`
	MultiCodigo              string  `json:"multicodigo"`
	ConsultaParcial          *string `json:"consultaparcial"`
	FechaEntrada             *string `json:"fechaentrada"`
	Bloqueado                int     `json:"bloqueado"`
	SignoEspecial            *string `json:"signoespecial"`
	Observacion              string  `json:"observacion"`
	Dibujo                   *string `json:"dibujo"`
	DibujoID                 int     `json:"dibujoid"`
}

func (AlbaranProveedorArticulo) TableName() string {
	return "albaranproveedorarticulo"
}
