package model

// TableRow 商品表格行数据
type TableRow struct {
	// 商品图标 URL
	Icon string `json:"icon"`
	// 商品 ID
	ID string `json:"id"`
	// 商品条码
	BarCode string `json:"barCode"`
	// 商品名称
	Name string `json:"name"`
	// 商品名称中文
	NombreCN string `json:"nombreCN"`
	// 商品名称英文
	NombreES string `json:"nombreES"`
	// 商品价格
	Price float64 `json:"price"`
	// 商品销售价格
	SalePrice float64 `json:"salePrice"`
	// 商品数量
	Quantity int `json:"quantity"`
	// 商品分类 ID
	ClassID int `json:"classId"`
	// 建议零售价 若无返回 -1
	SuggestedSalePrice int `json:"suggestedSalePrice"`
}

// ArticuloImportUploadDTO 商品导入上传DTO
type ArticuloImportUploadDTO struct {
	// 0 按 id匹配, 1 按 条码匹配, 2 id和条码都匹配
	Type int `json:"type"`
	// 商品数据列表
	Data []TableRow2 `json:"data"`
	// 是否更新销售价
	UpdateSalePrice bool `json:"updateSalePrice"`
	// 供应商 ID
	ProviderID int64 `json:"providerId"`
	// 不存在的商品将自动添加 存在的商品仅更新销售价
	UpdateOnly bool `json:"updateOnly"`
}

type TableRow2 struct {
	// 商品图标 URL
	Icon string `json:"icon"`
	// 商品 ID
	ID string `json:"id"`
	// 商品条码
	BarCode string `json:"barCode"`
	// 商品名称
	Name string `json:"name"`
	// 商品价格
	Price string `json:"price"`
	// 商品销售价格
	SalePrice float64 `json:"salePrice"`
	// 商品数量
	Quantity string `json:"quantity"`
	// 商品分类 ID
	ClassID string `json:"classId"`
	// 建议零售价 若无返回 -1
	SuggestedSalePrice int `json:"suggestedSalePrice"`
}

// ResolveResult 解析结果
type ResolveResult struct {
	Binding  interface{} `json:"binding"`
	Resolver interface{} `json:"resolver"`
}

// ArticleImportPageResolver 商品导入页面解析器接口
type ArticleImportPageResolver interface {
	GetExcelDownloadUrl() string
	GetTableData() []TableRow
	GetDomain() string
	Init(url string) error
}

// ArticuloTableImportService 商品表格导入服务接口
type ArticuloTableImportService interface {
	Resolve(url string) (*ResolveResult, error)
	Import(empresaID int64, empleadoID int, importType int, data []TableRow, updateSalePrice bool, updateOnly bool) (bool, error)
}
