package model

type ZbmParam struct {
	CodePrefix string `json:"codePrefix"`
	CodeLength int    `json:"codeLength"`
}

type ArticuloService interface {
	Scan(request ArticuloScanRequest) *ArticuloScanResult
	Update(request ArticuloInputRequest) interface{}
	Edit(ac Articulo) interface{}
	Add(request ArticuloInputRequest) interface{}
	GetAcClass() []ArticuloClase
	GetProveedor() []Proveedor
	UpdateByArticuloIDOrCodigoBarra(articulo Articulo) int
	GetByArticuloIDOrCodigoBarra(articuloID string) []Articulo
	GetByArticuloIDOrCodigoBarraLike(articuloID string) []Articulo
	GetByArticuloIDOrCodigoBarraActually(articuloID string) []Articulo
	GetByArticuloID(articuloID string) *Articulo
	GetByProductName(productName string) []Articulo
	Zbm(param ZbmParam) interface{}
	UpdateDibujoID(articuloID string, dibujoID int64) error
}
