package model

// IvaTipo IVA税率信息
type IvaTipo struct {
	IVAID       uint16  `gorm:"column:IVAID;primaryKey"` // smallint unsigned
	Nombre      string  `gorm:"column:Nombre;size:50"`
	IVA         float64 `gorm:"column:IVA;type:decimal(6,3);not null;default:0.000"`
	REQ         float64 `gorm:"column:REQ;type:decimal(6,3);not null;default:0.000"`
	IVA1        float64 `gorm:"column:IVA1;type:decimal(6,3);not null;default:0.000"`
	REQ1        float64 `gorm:"column:REQ1;type:decimal(6,3);not null;default:0.000"`
	IVA2        float64 `gorm:"column:IVA2;type:decimal(6,3);not null;default:0.000"`
	REQ2        float64 `gorm:"column:REQ2;type:decimal(6,3);not null;default:0.000"`
	IVA3        float64 `gorm:"column:IVA3;type:decimal(6,3);not null;default:0.000"`
	REQ3        float64 `gorm:"column:REQ3;type:decimal(6,3);not null;default:0.000"`
	IVA4        float64 `gorm:"column:IVA4;type:decimal(6,3);not null;default:0.000"`
	REQ4        float64 `gorm:"column:REQ4;type:decimal(6,3);not null;default:0.000"`
	IVA5        float64 `gorm:"column:IVA5;type:decimal(6,3);not null;default:0.000"`
	REQ5        float64 `gorm:"column:REQ5;type:decimal(6,3);not null;default:0.000"`
	IVA6        float64 `gorm:"column:IVA6;type:decimal(6,3);not null;default:0.000"`
	REQ6        float64 `gorm:"column:REQ6;type:decimal(6,3);not null;default:0.000"`
	IVA7        float64 `gorm:"column:IVA7;type:decimal(6,3);not null;default:0.000"`
	REQ7        float64 `gorm:"column:REQ7;type:decimal(6,3);not null;default:0.000"`
	IVA8        float64 `gorm:"column:IVA8;type:decimal(6,3);not null;default:0.000"`
	REQ8        float64 `gorm:"column:REQ8;type:decimal(6,3);not null;default:0.000"`
	IVA9        float64 `gorm:"column:IVA9;type:decimal(6,3);not null;default:0.000"`
	REQ9        float64 `gorm:"column:REQ9;type:decimal(6,3);not null;default:0.000"`
	Bloqueado   int     `gorm:"column:Bloqueado;not null;default:0"`
	Observacion *string `gorm:"column:Observacion;size:255"`
}

// TableName 指定表名
func (IvaTipo) TableName() string {
	return "ivatipo"
}

// IvaTipoService IVA税率服务接口
type IvaTipoService interface {
	GetIvaById(ivaId int) *IvaTipo
} 