package service

import (
	"log"
	"supermarket-go/internal/model"
	"gorm.io/gorm"
)

type ClienteService struct {
	db *gorm.DB
}

func NewClienteService(db *gorm.DB) *ClienteService {
	log.Println("[INFO] 创建新的 ClienteService 实例")
	return &ClienteService{db: db}
}

func (s *ClienteService) ListAllClients() []model.Cliente {
	log.Println("[INFO] 查询所有客户信息")
	
	var clientes []model.Cliente
	err := s.db.Find(&clientes).Error
	if err != nil {
		log.Printf("[ERROR] 查询所有客户失败: %v", err)
		return []model.Cliente{}
	}
	
	log.Printf("[INFO] 成功查询到 %d 个客户", len(clientes))
	return clientes
}
