package service

import (
	"supermarket-go/internal/model"
	"gorm.io/gorm"
)

// DibujoService 图片服务
type DibujoService struct {
	db *gorm.DB
}

// NewDibujoService 创建图片服务
func NewDibujoService(db *gorm.DB) *DibujoService {
	return &DibujoService{
		db: db,
	}
}

// Save 保存图片
func (s *DibujoService) Save(dibujo *model.Dibujo) error {
	return s.db.Create(dibujo).Error
}

// GetByID 根据ID获取图片
func (s *DibujoService) GetByID(id int64) (*model.Dibujo, error) {
	var dibujo model.Dibujo
	if err := s.db.Where("DibujoID = ?", id).First(&dibujo).Error; err != nil {
		return nil, err
	}
	return &dibujo, nil
} 