package service

import (
	"gorm.io/gorm"
	"log"
	"supermarket-go/internal/model"
)

type IvaTipoServiceImpl struct {
	db *gorm.DB
}

func NewIvaTipoService(db *gorm.DB) model.IvaTipoService {
	return &IvaTipoServiceImpl{db: db}
}

// GetIvaById 根据IVA ID获取IVA税率信息
func (s *IvaTipoServiceImpl) GetIvaById(ivaId int) *model.IvaTipo {
	log.Printf("[INFO] 开始获取IVA税率信息: IVAID=%d", ivaId)

	var ivaTipo model.IvaTipo
	if err := s.db.Where("IVAID = ?", ivaId).First(&ivaTipo).Error; err != nil {
		log.Printf("[ERROR] 获取IVA税率信息失败: %v", err)
		return nil
	}

	log.Printf("[INFO] 成功获取IVA税率信息: IVAID=%d, IVA=%.3f, REQ=%.3f", 
		ivaTipo.IVAID, ivaTipo.IVA, ivaTipo.REQ)
	return &ivaTipo
} 