package util

import (
	"io"
	"net/http"
	"os"
	"path/filepath"
)

// NetworkUtils 网络工具类
type NetworkUtils struct{}

// DownloadFile 下载文件到指定路径
func (n *NetworkUtils) DownloadFile(url, savePath string) (*os.File, error) {
	// 创建目录
	if err := os.MkdirAll(filepath.Dir(savePath), 0755); err != nil {
		return nil, err
	}

	// 创建文件
	file, err := os.Create(savePath)
	if err != nil {
		return nil, err
	}
	defer file.Close()

	// 下载文件
	resp, err := http.Get(url)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	// 写入文件
	_, err = io.Copy(file, resp.Body)
	if err != nil {
		return nil, err
	}

	return file, nil
}

// DownloadFileIS 下载文件并返回输入流
func (n *NetworkUtils) DownloadFileIS(url string) (io.ReadCloser, error) {
	resp, err := http.Get(url)
	if err != nil {
		return nil, err
	}
	return resp.Body, nil
} 