package util

import (
	"strconv"
)

// Response 统一响应结构
type Response struct {
	Code    string      `json:"code"`
	Message string      `json:"message"`
	Data    interface{} `json:"data"`
}

// BuildResponse 构建响应
func BuildResponse(code int, message string, data interface{}) Response {
	codeStr := "200"
	if code != 0 {
		codeStr = strconv.Itoa(code)
	}

	if message == "" {
		message = ""
	}

	return Response{
		Code:    codeStr,
		Message: message,
		Data:    data,
	}
}

// BuildSuccessResponse 构建成功响应
func BuildSuccessResponse(message string, data interface{}) Response {
	return BuildResponse(200, message, data)
}

// BuildSuccessResponseData 构建成功响应（只有数据）
func BuildSuccessResponseData(data interface{}) Response {
	return BuildResponse(200, "", data)
}

// BuildBadRequestResponse 构建错误请求响应
func BuildBadRequestResponse(message string, data interface{}) Response {
	return BuildResponse(400, message, data)
}

// BuildInternalServerErrorResponse 构建服务器错误响应
func BuildInternalServerErrorResponse(message string, data interface{}) Response {
	return BuildResponse(500, message, data)
} 